// Copyright 1999-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.


#import <OmniAppKit/NSOutlineView-OAExtensions.h>

#ifdef YELLOW_BOX	// NSOutlineView only available in YB, not OpenStep

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSOutlineView-OAExtensions.m,v 1.5 2000/01/19 23:35:46 kc Exp $")

@implementation NSOutlineView (OAExtensions)

- (id) selectedItem;
{
    if ([self numberOfSelectedRows] != 1)
        return nil;

    return [self itemAtRow: [self selectedRow]];
}

- (NSArray *) selectedItems;
{
    NSMutableArray *items;
    NSEnumerator   *rowEnum;
    NSNumber       *row;
    
    items = [NSMutableArray array];
    rowEnum = [self selectedRowEnumerator];
    while ((row = [rowEnum nextObject]))
        [items addObject: [self itemAtRow: [row intValue]]];

    return items;
}

@end

#endif	// YELLOW_BOX
