// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/NSScrollView-OAExtensions.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSScrollView-OAExtensions.m,v 1.7 2000/02/21 11:51:20 wjs Exp $")

@implementation NSScrollView (OAExtensions)

- (void)freeGStates;
{
    [self releaseGState];
    [[self contentView] releaseGState];
}

/* Overrides of View extensions */

- (void)scrollDownByPercentage:(float)percentage;
{
    [[self documentView] scrollDownByPercentage:percentage];
}

- (float)fraction;
{
    return [[self documentView] fraction];
}

- (void)setFraction:(float)newFract;
{
    [[self documentView] setFraction:newFract];
}


@end
