// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/NSWindow-OAExtensions.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSWindow-OAExtensions.m,v 1.8 2000/01/19 23:35:48 kc Exp $")

@implementation NSWindow (OAExtensions)

// Overriding Apple's -setFrameFromString: implementation so that it supports multiple screens.
// TODO:  Adjust our frame when the current screen size differs from the saved screen size.
- (void)setFrameFromString:(NSString *)string;
{
    NSArray *parts;

    parts = [string componentsSeparatedByString:@" "];
    if ([parts count] >= 4) {
        NSRect rect;

        rect.origin.x = [[parts objectAtIndex:0] floatValue];
        rect.origin.y = [[parts objectAtIndex:1] floatValue];
        rect.size.width = [[parts objectAtIndex:2] floatValue];
        rect.size.height = [[parts objectAtIndex:3] floatValue];
        [self setFrame:rect display:YES];
    }
}

- (BOOL)setFrameUsingName:(NSString *)aName;
{
    NSUserDefaults *defaults;
    NSString *string;

    defaults = [NSUserDefaults standardUserDefaults];
    aName = [@"NSWindow Frame " stringByAppendingString:aName];
    string = [defaults stringForKey:aName];
    if (string == nil || [string length] == 0) {
        return NO;
    } else {
        [self setFrameFromString:string];
        return YES;
    }
}

- (NSPoint)frameTopLeftPoint;
{
    NSRect myFrame;

    myFrame = [self frame];
    return NSMakePoint(myFrame.origin.x, myFrame.origin.y + myFrame.size.height);
}


@end
