// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceClient.h,v 1.10 2000/02/22 06:35:40 wjs Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSDictionary, NSNotification, NSString;
@class NSBox, NSTextField, NSView;
@class NSUserDefaults;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet

@interface OAPreferenceClient : OFObject
{
    IBOutlet NSBox *controlBox;
    IBOutlet NSView *initialFirstResponder;

    NSString *title;
    NSArray *defaultsArray;
    NSUserDefaults *defaults;
}

- initWithTitle:(NSString *)newTitle defaultsArray:(NSArray *)newDefaultsArray;
    // Creates a new preferences client (with the specified title), which manipulates the specified defaults.

- (NSBox *)controlBox;
    // The controlBox outlet points to the box that will be transferred into the Preferences window when this preference client is selected.
- (NSView *)initialFirstResponder;


- (void)resetFloatValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;
- (void)resetIntValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;


// This is an action, so don't change its type
- (IBAction)restoreDefaults:(id)sender;
    // Restores all defaults for this preference client to their original installation values.
- (void)restoreDefaultsNoPrompt;

- (void)pickDirectoryForTextField:(NSTextField *)textField;
    // Prompts the user for a directory (using an open panel), then updates the text field to display it and calls -setValueForSender: specifying that field as the sender.

// The default implementation of these methods does nothing:  each subclass is expected to implement them.

- (void)updateUI;
    // This method updates the UI to reflect the current defaults

- (void)setValueForSender:(id)sender;
    // This method updates defaults for a modified UI element (the sender).

// These are public so they can be subclassed.
- (void)valuesHaveChanged;
    // This method should be called whenever a default is changed programmatically.  The default implementation simply calls -updateUI.

- (void)controlTextDidEndEditing:(NSNotification *)notification;
    // The default implementation calls -setValueForSender:, setting the sender to be the notification object (i.e., the text field).

// NSNibAwaking informal protocol
- (void)awakeFromNib;
    // Be sure to call super if you subclass this

@end
