// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceClientRecord.h,v 1.7 2000/01/19 23:35:51 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSDictionary;
@class NSImage;

@interface OAPreferenceClientRecord : OFObject
{
    NSString                   *className;
    NSString                   *title;
    NSString                   *iconName;
    NSString                   *iconTitle;
    NSString                   *nibName;
    NSDictionary *defaultsDictionary;
    NSArray *defaultsArray;
    float                       ordering;

    NSImage *iconImage;
}

- (NSImage *)iconImage;

- (NSString *)className;
- (NSString *)title;
- (NSString *)iconName;
- (NSString *)iconTitle;
- (NSString *)nibName;
- (NSDictionary *)defaultsDictionary;
- (NSArray *)defaultsArray;
- (float)ordering;

- (void)setClassName:(NSString *)newClassName;
- (void)setTitle:(NSString *)newTitle;
- (void)setIconName:(NSString *)newIconName;
- (void)setIconTitle:(NSString *)newIconName;
- (void)setNibName:(NSString *)newNibName;
- (void)setDefaultsDictionary:(NSDictionary *)newDefaultsDictionary;
- (void)setDefaultsArray:(NSArray *)newDefaultsArray;
- (void)setOrdering:(float)newOrdering;

- (NSComparisonResult)compare:(OAPreferenceClientRecord *)other;

@end
