// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceController.h,v 1.8 2000/01/19 23:35:51 kc Exp $

#import <OmniFoundation/OFObject.h>
#import <Foundation/NSGeometry.h>

@class NSMutableArray, NSMutableDictionary;
@class NSBox, NSImageView, NSTableView, NSTextField, NSWindow;
@class OAPreferenceClient, OAPreferenceController;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet

@interface OAPreferenceController : OFObject
{
    IBOutlet NSWindow *window;
    IBOutlet NSBox *box;
    IBOutlet NSTableView *tableView;
    IBOutlet NSTextField *titleTextField;
    IBOutlet NSImageView *imageView;

    NSString *categoryName;
    OAPreferenceClient *currentClient;
    NSMutableArray *clientRecordsArray;
    NSMutableDictionary *clientClassNamesToClientRecordDictionary;
    NSMutableDictionary *clientClassNamesToInstancesDictionary;

    NSSize preferredBoxSize;
    NSSize windowExtraSize;
}

+ (OAPreferenceController *)sharedPreferenceControllerNamed:(NSString *)categoryName;
+ (OAPreferenceController *)sharedPreferenceController;

- initWithCategoryName:(NSString *)controllerCategoryName;

// API
- (void)setCurrentClientByName:(NSString *)clientName;
- (OAPreferenceClient *)clientNamed:(NSString *)clientName;
- (void)close;

// Actions
- (IBAction)showPreferencesPanel:(id)sender;
- (IBAction)selectPreference:(NSTableView *)sender;
- (IBAction)restoreDefaults:(id)sender;


@end
