// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAExtendedOutlineView.h,v 1.6 2000/05/25 01:44:18 kc Exp $

#import <AppKit/NSNibDeclarations.h> // For IBOutlet
#import <AppKit/NSOutlineView.h>

@class NSPasteboard;

@interface OAExtendedOutlineView : NSOutlineView
{
    struct {
        unsigned int isDraggingDestination:1;
        unsigned int isDraggingDestinationAcceptable:1;
        unsigned int justAcceptedDrag:1;
    } flags;
    unsigned int dragSourceRow, dragSourceLevel;
    unsigned int dragDestinationRow, dragDestinationLevel;
    
    id draggingSourceItem;
}

// API
- (id)parentItemForRow:(int)row child:(unsigned int *)childIndexPointer;
- (id)parentItemForRow:(int)row indentLevel:(unsigned int)childLevel child:(unsigned int *)childIndexPointer;
// Actions
- (IBAction)expandAll:(id)sender;
- (IBAction)contractAll:(id)sender;
- (IBAction)expandSelection:(id)sender;
- (IBAction)contractSelection:(id)sender;
//
- (IBAction)copy:(id)sender;
- (IBAction)cut:(id)sender;
- (IBAction)delete:(id)sender;
- (IBAction)paste:(id)sender;


@end

@interface NSObject(OAExtendedOutlineViewDataSource)
// Implement this if you want to accept dragging in.
- (NSArray *)outlineViewAcceptedPasteboardTypes:(OAExtendedOutlineView *)outlineView;

// If you implement the above, then you MUST implement these:
- (BOOL)outlineView:(OAExtendedOutlineView *)outlineView allowPasteItemFromPasteboard:(NSPasteboard *)pasteboard parentItem:(id)parentItem child:(int)index;
- (void)outlineView:(OAExtendedOutlineView *)outlineView pasteItemFromPasteboard:(NSPasteboard *)pasteboard parentItem:(id)parentItem child:(int)index;

- (void)outlineView:(OAExtendedOutlineView *)outlineView parentItem:(id)parentItem moveChildren:(NSArray *)movingChildren toNewParentItem:(id)newParentItem;

// Implement this if you want to allow dragging out.
- (void)outlineView:(OAExtendedOutlineView *)outlineView copyItem:(id)item toPasteboard:(NSPasteboard *)pasteboard;
- (void)outlineView:(OAExtendedOutlineView *)outlineView deleteItem:(id)item parentItem:(id)parentItem;

- (NSUndoManager *)undoManagerForOutlineView:(OAExtendedOutlineView *)outlineView;
@end
