// Copyright 1999-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.


#import <OmniAppKit/NSOutlineView-OAExtensions.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSOutlineView-OAExtensions.m,v 1.9 2000/07/10 23:55:10 krevis Exp $")

@implementation NSOutlineView (OAExtensions)

- (id)selectedItem;
{
    if ([self numberOfSelectedRows] != 1)
        return nil;

    return [self itemAtRow: [self selectedRow]];
}

- (void)setSelectedItem:(id)item;
{
    int row;

    row = [self rowForItem:item];
    if (row != NSNotFound)
        [self selectRow:row byExtendingSelection:NO];
    else
        [self deselectAll: nil];
}


- (NSArray *)selectedItems;
{
    NSMutableArray *items;
    NSEnumerator *rowEnum;
    NSNumber *row;
    
    items = [NSMutableArray array];
    rowEnum = [self selectedRowEnumerator];
    while ((row = [rowEnum nextObject]))
        [items addObject:[self itemAtRow:[row intValue]]];

    return items;
}

- (void)setSelectedItems:(NSArray *)items;
{
    NSHashTable *itemTable;
    unsigned int itemIndex, rowIndex, rowCount;
    id item;
    BOOL shouldExtendSelection;
    
    [self deselectAll:nil];

    itemIndex = [items count];
    if (!itemIndex)
        return;
        
    // Build a has table of the objects to select to avoid a O(N^2) loop.
    // This also uniques the list of objects nicely, should it not already be.
    itemTable = NSCreateHashTable(NSNonOwnedPointerHashCallBacks, itemIndex);
    while (itemIndex--)
        NSHashInsert(itemTable, [items objectAtIndex:itemIndex]);
        
    // Now, do a O(N) search through all of the rows and select any for which we have objects
    shouldExtendSelection = NO;
    rowCount = [self numberOfRows];
    for (rowIndex = 0; rowIndex < rowCount; rowIndex++) {
        item = [self itemAtRow:rowIndex];
        if (NSHashGet(itemTable, item)) {
            // We should be able to always extend the selection, since we deselected everything above. However, as of OS X DP4, if we do that, it sometimes triggers an assertion and NSLog in NSTableView. (Usually that happens after dragging an item.)
            [self selectRow:rowIndex byExtendingSelection:shouldExtendSelection];
            shouldExtendSelection = YES;
        }
    }
    
    NSFreeHashTable(itemTable);
}


@end
