// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSView-OAExtensions.h,v 1.11 2000/07/03 03:42:34 bungi Exp $

#import <AppKit/NSView.h>

@class NSFont;

typedef enum _OAImageSlideDirection {
    OALeftSlideDirection,
    OARightSlideDirection,
    OAUpSlideDirection,
    OADownSlideDirection
} OAImageSlideDirection;

@interface NSView (OAExtensions)

// Drawing
- (void)drawRoundedRect:(NSRect)rect cornerRadius:(float)radius color:(NSColor *)color;
- (void)drawHorizontalSelectionInRect:(NSRect)rect;
- (void) drawSelfAndSubviewsInRect: (NSRect) rect;

// Scrolling
- (void)scrollDownByPercentage:(float)percentage;
- (float)fraction;
- (void)setFraction:(float)newFract;

// Dragging
- (BOOL)shouldStartDragFromMouseDownEvent:(NSEvent *)event dragSlop:(float)dragSlop finalEvent:(NSEvent **)finalEventPointer;

// Resizing
- (void) morphToFrame: (NSRect) newFrame;

// View fade in/out
- (void) fadeInSubview: (NSView *) subview;
- (void) fadeOutAndRemoveFromSuperview;

// Image sliding
- (NSImage *) imageForRect: (NSRect) rect;
- (void) slideOutOldImage: (NSImage *) oldImage
                 newImage: (NSImage *) newImage
           slideDirection: (OAImageSlideDirection) direction;

@end
