// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/NSWindow-OAExtensions.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSWindow-OAExtensions.m,v 1.10 2000/06/26 11:06:47 bungi Exp $")


#define TRANSITION_TIME (0.25)


@implementation NSWindow (OAExtensions)

- (NSPoint)frameTopLeftPoint;
{
    NSRect windowFrame;

    windowFrame = [self frame];
    return NSMakePoint(NSMinX(windowFrame), NSMaxY(windowFrame));
}

// TODO: If the difference between frames is small, we should ensure that we change by at least one pixel per loop in at least one direction.  In this case, we could end up looping for LESS than TRANSITION_TIME.
- (void) morphToFrame: (NSRect) newFrame;
{
    NSRect          currentFrame;
    NSTimeInterval  start, current, elapsed;
    
    currentFrame = [self frame];

    start = [NSDate timeIntervalSinceReferenceDate];    
    while (YES) {
        float  ratio;
        NSRect stepFrame;
        
        current = [NSDate timeIntervalSinceReferenceDate];
        elapsed = current - start;
        if (elapsed >  TRANSITION_TIME)
            break;

        ratio = elapsed / TRANSITION_TIME;
        stepFrame.origin.x = ratio * newFrame.origin.x + (1.0 - ratio) * currentFrame.origin.x;
        stepFrame.origin.y = ratio * newFrame.origin.y + (1.0 - ratio) * currentFrame.origin.y;
        stepFrame.size.width = ratio * newFrame.size.width + (1.0 - ratio) * currentFrame.size.width;
        stepFrame.size.height = ratio * newFrame.size.height + (1.0 - ratio) * currentFrame.size.height;
        
        [self setFrame: stepFrame display: YES];
    }
    
    // Make sure we don't end up with round off errors
    [self setFrame: newFrame display: YES];
}


@end
