// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/OAPreferenceClientRecord.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OmniAppKit/OAPreferenceClient.h>
#import <OmniAppKit/OAPreferenceController.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceClientRecord.m,v 1.9 2000/07/07 23:31:20 bungi Exp $")

@implementation OAPreferenceClientRecord

- (void)dealloc
{
    [className release];
    [title release];
    [shortTitle release];
    [iconName release];
    [iconTitle release];
    [nibName release];
    [defaultsDictionary release];
    [defaultsArray release];
    [iconImage release];
    [clientInstance release];
    
    [super dealloc];
}


//

- (NSImage *)iconImage;
{
    NSBundle *bundle;
    NSString *path;
    
    if (iconImage)
        return iconImage;

    bundle = [OFBundledClass bundleForClassNamed:className];
    path = [bundle pathForResource:iconName ofType:@"tiff"];
    iconImage = [[NSImage alloc] initWithContentsOfFile: path];
    return iconImage;
}

- (NSString *)className;
{
    return className;
}

- (NSString *)title;
{
    return title;
}

- (NSString *) shortTitle;
{
    return shortTitle ? shortTitle : title;
}

- (NSString *)iconName;
{
    return iconName;
}

- (NSString *)iconTitle;
{
    return iconTitle;
}

- (NSString *)nibName;
{
    return nibName;
}

- (NSDictionary *)defaultsDictionary;
{
    return defaultsDictionary;
}

- (NSArray *)defaultsArray;
{
    return defaultsArray;
}

- (float)ordering;
{
    return ordering;
}

- (void)setClassName:(NSString *)newClassName;
{
    if (className == newClassName)
        return;
    [className release];
    className = [newClassName retain];
}

- (void)setTitle:(NSString *)newTitle;
{
    if (title == newTitle)
        return;
    [title release];
    title = [newTitle retain];
}

- (void)setShortTitle:(NSString *)newShortTitle;
{
    if (shortTitle == newShortTitle)
        return;
    [shortTitle release];
    shortTitle = [newShortTitle retain];
}

- (void)setIconName:(NSString *)newIconName;
{
    if (iconName == newIconName)
        return;
    [iconName release];
    iconName = [newIconName retain];
}

- (void)setIconTitle:(NSString *)newIconTitle;
{
    if (iconTitle == newIconTitle)
        return;
    [iconTitle release];
    iconTitle = [newIconTitle retain];
}

- (void)setNibName:(NSString *)newNibName;
{
    if (nibName == newNibName)
        return;
    [nibName release];
    nibName = [newNibName retain];
}

- (void)setDefaultsDictionary:(NSDictionary *)newDefaultsDictionary;
{
    if (defaultsDictionary == newDefaultsDictionary)
        return;
    [defaultsDictionary release];
    defaultsDictionary = [newDefaultsDictionary retain];
}

- (void)setDefaultsArray:(NSArray *)newDefaultsArray;
{
    if (defaultsArray == newDefaultsArray)
        return;
    [defaultsArray release];
    defaultsArray = [newDefaultsArray retain];
}

- (void)setOrdering:(float)newOrdering;
{
    ordering = newOrdering;
}

- (NSComparisonResult)compare:(OAPreferenceClientRecord *)other;
{
    if (![other isKindOfClass:[self class]])
	return NSOrderedAscending;

    if (other->ordering > ordering)
	return NSOrderedAscending;
    if (other->ordering < ordering)
	return NSOrderedDescending;
    return NSOrderedSame;
}

- (OAPreferenceClient *) clientInstanceInController: (OAPreferenceController *) controller;
{
    Class clientClass;

    if (clientInstance)
        return clientInstance;
    
    [controller setTitle: [NSString stringWithFormat:@"Loading %@...", title]];

    clientClass = [OFBundledClass classNamed:className];
    if (!defaultsArray)
        defaultsArray = [[defaultsDictionary allKeys] retain];
    
    clientInstance = [[clientClass alloc] initWithTitle:title defaultsArray:defaultsArray];

    if (nibName)
        [NSBundle loadNibNamed:nibName owner:clientInstance];
        
    return clientInstance;
}


//
// Debugging
//

- (NSMutableDictionary *) debugDictionary;
{
    NSMutableDictionary *dict;
    
    dict = [super debugDictionary];
    if (className)
        [dict setObject: className forKey: @"className"];
    if (title)
        [dict setObject: title forKey: @"title"];
    if (iconName)
        [dict setObject: iconName forKey: @"iconName"];
    if (iconTitle)
        [dict setObject: iconTitle forKey: @"iconTitle"];
    if (nibName)
        [dict setObject: nibName forKey: @"nibName"];
    if (defaultsDictionary)
        [dict setObject: defaultsDictionary forKey: @"defaultsDictionary"];
    if (defaultsArray)
        [dict setObject: defaultsArray forKey: @"defaultsArray"];
    [dict setObject: [NSNumber numberWithFloat: ordering] forKey: @"ordering"];
    if (iconImage)
        [dict setObject: iconImage forKey: @"iconImage"];
    if (clientInstance)
        [dict setObject: clientInstance forKey: @"clientInstance"];
    return dict;
}

@end
