// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/OAAquaButton.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAAquaButton.m,v 1.1 2000/03/15 08:57:02 wjs Exp $")

@implementation OAAquaButton

- (void)dealloc;
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}

// NSView subclass

- (void)viewWillMoveToWindow:(NSWindow *)newWindow;
{
    BOOL currentWindowIsKey = YES;
    NSWindow *currentWindow;

    currentWindow = [self window];
    if (currentWindow) {
        [[NSNotificationCenter defaultCenter] removeObserver:self name:NSWindowDidBecomeKeyNotification object:currentWindow];
        [[NSNotificationCenter defaultCenter] removeObserver:self name:NSWindowDidResignKeyNotification object:currentWindow];
        currentWindowIsKey = [currentWindow isKeyWindow];
    }
    
    [super viewWillMoveToWindow:newWindow];

    if (newWindow) {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(windowDidBecomeKey:) name:NSWindowDidBecomeKeyNotification object:newWindow];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(windowDidResignKey:) name:NSWindowDidResignKeyNotification object:newWindow];

        if ([newWindow isKeyWindow]) {
            if (!currentWindowIsKey)
                [self windowDidBecomeKey:nil];
        } else {
            if (currentWindowIsKey)
                [self windowDidResignKey:nil];
        }
    }
}

// NSWindowNotifications

static NSString *OAAquaGraySuffix = @"Gray";

- (void)windowDidBecomeKey:(NSNotification *)notification;
{
    NSString *imageName;
    NSImage *newImage;

    imageName = [[self image] name];
    if (!imageName)
        return;

    if (![imageName hasSuffix:OAAquaGraySuffix])
        return;
    
    newImage = [NSImage imageNamed:[imageName substringToIndex:[imageName length]-[OAAquaGraySuffix length]]];

    if (newImage)
        [self setImage:newImage];
}

- (void)windowDidResignKey:(NSNotification *)notification;
{
    NSString *imageName;
    NSImage *newImage;

    imageName = [[self image] name];
    if (!imageName)
        return;

    newImage = [NSImage imageNamed:[imageName stringByAppendingString:OAAquaGraySuffix]];

    if (newImage)
        [self setImage:newImage];
}

@end
