// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAWindowCascade.h,v 1.1 2000/07/05 20:14:02 bungi Exp $

#import <OmniFoundation/OFObject.h>
#import <Foundation/NSGeometry.h>

@class NSArray;
@class NSScreen;

@interface OAWindowCascade : OFObject
{
    NSScreen     *screen;
    unsigned int  step;
    unsigned int  maxStep;
    NSRect        cascadeRect;
}

- initWithScreen: (NSScreen *) aScreen;
- (NSScreen *) screen;

- (NSRect) nextWindowFrameForSize: (NSSize) windowSize
                  avoidingWindows: (NSArray *) windowsToAvoid;
                  
@end
