// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSScrollView-OAExtensions.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "NSView-OAExtensions.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSScrollView-OAExtensions.m,v 1.8 2000/10/26 03:44:06 kc Exp $")

@implementation NSScrollView (OAExtensions)

- (void)freeGStates;
{
    [self releaseGState];
    [[self contentView] releaseGState];
}

// Overrides of NSView (OAExtensions)

- (void)scrollDownByPercentage:(float)percentage;
{
    [[self documentView] scrollDownByPercentage:percentage];
}

- (void)scrollRightByPercentage:(float)percentage;
{
    [[self documentView] scrollRightByPercentage:percentage];
}

- (float)fraction;
{
    return [[self documentView] fraction];
}

- (void)setFraction:(float)newFract;
{
    [[self documentView] setFraction:newFract];
}


@end
