// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSView-OAExtensions.h,v 1.16 2000/10/26 03:44:06 kc Exp $

#import <AppKit/NSView.h>

#import <Foundation/NSDate.h>

@class NSBitmapImageRep, NSFont;

typedef enum _OAImageSlideDirection {
    OALeftSlideDirection,
    OARightSlideDirection,
    OAUpSlideDirection,
    OADownSlideDirection
} OAImageSlideDirection;

@interface NSView (OAExtensions)

// Drawing
- (void)drawRoundedRect:(NSRect)rect cornerRadius:(float)radius color:(NSColor *)color;
- (void)drawHorizontalSelectionInRect:(NSRect)rect;
- (void)drawSelfAndSubviewsInRect:(NSRect)rect;

// Scrolling
- (void)scrollDownByPercentage:(float)percentage;
- (void)scrollRightByPercentage:(float)percentage;

- (float)fraction;
- (void)setFraction:(float)newFract;

// Dragging
- (BOOL)shouldStartDragFromMouseDownEvent:(NSEvent *)event dragSlop:(float)dragSlop finalEvent:(NSEvent **)finalEventPointer;

// Resizing
- (void) morphToFrame: (NSRect) newFrame overTimeInterval: (NSTimeInterval) morphInterval;

// View fade in/out
- (void) fadeInSubview: (NSView *) subview overTimeInterval: (NSTimeInterval) fadeInterval;
- (void) fadeOutAndRemoveFromSuperviewOverTimeInterval: (NSTimeInterval) fadeInterval;

// Image sliding
- (NSBitmapImageRep *) bitmapForRect: (NSRect) rect;
- (NSImage *) imageForRect: (NSRect) rect;
- (void) slideOutOldBitmapImageRep: (NSBitmapImageRep *) oldImageRep
                 newBitmapImageRep: (NSBitmapImageRep *) newImageRep
                    slideDirection: (OAImageSlideDirection) direction
                  overTimeInterval: (NSTimeInterval) slideInterval;

// Debugging
- (void)logViewHierarchy;

@end
