// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/OAPreferenceCategory.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

#import <OmniAppKit/OAPreferenceClientRecord.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceCategory.m,v 1.2 2000/07/07 23:31:19 bungi Exp $")

@implementation OAPreferenceCategory

- initWithName: (NSString *) aName;
{
    name = [aName copy];
    clientRecords = [[NSMutableArray alloc] init];
    
    return self;
}

- (void) dealloc;
{
    OBPRECONDITION(NO);
}

- (NSString *) name;
{
    return name;
}

- (NSArray *) clientRecords;
{
    return clientRecords;
}

- (void)registerClassName:(NSString *)className
              description:(NSDictionary *) description;
{
    OAPreferenceClientRecord *newRecord;
    unsigned int insertionIndex, preferenceCount;
    NSString *title, *iconName, *nibName, *iconTitle;
    NSString *orderingString;
    NSDictionary *defaultsDictionary;
    
    defaultsDictionary = [description objectForKey:@"defaultsDictionary"];
    if (defaultsDictionary)
        [[NSUserDefaults standardUserDefaults] registerDefaults:defaultsDictionary];
    else
        defaultsDictionary = [NSDictionary dictionary]; // placeholder

    title = [description objectForKey:@"title"];
    iconName = [description objectForKey:@"icon"];
    iconTitle = [description objectForKey:@"iconTitle"];
    nibName = [description objectForKey:@"nib"];
    
    if (!(className && title && iconName && nibName))
        return;

    newRecord = [[OAPreferenceClientRecord alloc] init];
    [newRecord setClassName:className];
    [newRecord setTitle:title];
    [newRecord setShortTitle:[description objectForKey:@"shortTitle"]];
    [newRecord setIconName:iconName];
    [newRecord setIconTitle:iconTitle ? iconTitle : title];
    [newRecord setNibName:nibName];
#warning TJW: We should probably init the defaultArray from the keys in the defaults dictionary, yes?
    [newRecord setDefaultsDictionary:defaultsDictionary];
    [newRecord setDefaultsArray:[description objectForKey:@"defaultsArray"]];

    orderingString = [description objectForKey:@"ordering"];
    if (orderingString)
        [newRecord setOrdering:[orderingString floatValue]];
    else
        [newRecord setOrdering:100.0];

    preferenceCount = [clientRecords count];
#warning TJW: Use OmniFoundation extension for inserting into sorted arrays
    for (insertionIndex = 0; insertionIndex < preferenceCount; insertionIndex++) {
        OAPreferenceClientRecord *otherRecord;

        otherRecord = [clientRecords objectAtIndex:insertionIndex];
        if ([newRecord ordering] < [otherRecord ordering])
            break;
    }

    [clientRecords insertObject:newRecord atIndex:insertionIndex];
    [newRecord release];
}

//
// Debuggging
//

- (NSMutableDictionary *) debugDictionary;
{
    NSMutableDictionary *dict;
    
    dict = [super debugDictionary];
    [dict setObject: name forKey: @"name"];
    [dict setObject: clientRecords forKey: @"clientRecords"];
    
    return dict;
}

@end
