// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceController.h,v 1.13 2000/08/06 01:26:13 neo Exp $

#import <OmniFoundation/OFObject.h>
#import <Foundation/NSGeometry.h>

@class NSMutableArray, NSMutableDictionary;
@class NSBox, NSImageView, NSMatrix, NSTabView, NSTextField, NSWindow;
@class OAPreferenceClient, OAPreferenceClientRecord, OAPreferenceCategory;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet

//debugging purposes - enable/disable smart tabs
#define USE_SMART_PREF_TABS 1

@interface OAPreferenceController : OFObject
{
    IBOutlet NSWindow *window;
    IBOutlet NSBox *box;
    IBOutlet NSBox *matrixBox;
    IBOutlet NSTabView *categoryTabView;
    IBOutlet NSMatrix *preferencesMatrix;
    
    NSMutableArray *categories;

    OAPreferenceCategory *nonretained_currentCategory;
    OAPreferenceClientRecord *nonretained_currentClientRecord;
    OAPreferenceClient *nonretained_currentClient;

    NSSize preferredBoxSize;
    NSSize windowExtraSize;
    
    NSRect oldMatrixFrame;
    NSRect oldBoxFrame;
}

+ (OAPreferenceController *)sharedPreferenceController;

// API
- (void)selectCategory: (OAPreferenceCategory *) category;
- (void)close;
- (void)setTitle: (NSString *) title;
- (void)setCurrentClientByName: (NSString *) name;

// Actions
- (IBAction)showPreferencesPanel:(id)sender;
- (IBAction)selectPreference:(id)sender;
- (IBAction)restoreDefaults:(id)sender;


@end
