// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/OAAquaButton.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/NSWindow-OAExtensions.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAAquaButton.m,v 1.6 2000/09/22 23:52:40 wiml Exp $")

static NSString *OAAquaClearSuffix = @"Clear";
static NSString *OAAquaGraphiteSuffix = @"Graphite";

// There is no good way in AppKit to determine the tint type.
// The have a method for getting an NSColor that is close to
// the tint, but that doesn't lead to a good solution for images.

#define AQUA_TINT 1
#define GRAPHITE_TINT 6

@interface NSView (NotYetPublicKeyChangedAPI)
- (void) _windowChangedKeyState;
@end

@interface OAAquaButton (PrivateAPI)
+ (void) _controlTintChanged: (NSNotification *) note;
- (void) _cacheImages;
@end

@implementation OAAquaButton

- (void)dealloc;
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [aquaImage release];
    [graphiteImage release];
    [clearImage release];
    [super dealloc];
}

- (void) setImage: (NSImage *) image;
{
    [aquaImage release];
    aquaImage = nil;
    [graphiteImage release];
    graphiteImage = nil;
    [clearImage release];
    clearImage = nil;

    // This will schedule a redraw
    [super setImage: image];
}

// NSView subclass

- (void)drawRect: (NSRect) rect;
{
    if (!aquaImage)
        [self _cacheImages];
    [super drawRect: rect];
}

// This will be made public in some form after Public Beta
- (void) _windowChangedKeyState;
{
    if ([_window shouldDrawAsKey]) {
        if (OACurrentControlTint() == GRAPHITE_TINT) {
            if (graphiteImage) {
                [super setImage: graphiteImage];
            }
        } else if (aquaImage) {
            [super setImage: aquaImage];
        }
    } else {
        if (clearImage) {
            [super setImage: clearImage];
        }
    }
}


@end


@implementation OAAquaButton (PrivateAPI)

- (void) _cacheImages;
{
    NSString *imageName;
    NSImage  *image;
    
    image = [self image];
    
    [aquaImage release];
    aquaImage = [image retain];
    [clearImage release];
    clearImage = nil;
    
    imageName = [[aquaImage name] stringByAppendingString:OAAquaClearSuffix];
    if (imageName)
        clearImage = [[NSImage imageNamed: imageName] retain];

    imageName = [[aquaImage name] stringByAppendingString:OAAquaGraphiteSuffix];
    if (imageName)
        graphiteImage = [[NSImage imageNamed: imageName] retain];

    // Set the images directly on the cells to avoid scheduling another
    // redraw.  We get called in the middle of draw rect the first time
    // around and don't want to be inefficient by drawing again after
    // caching images.
    if ([_window shouldDrawAsKey]) {
        if (OACurrentControlTint() == GRAPHITE_TINT) {
            if (graphiteImage) {
                [[self cell] setImage: graphiteImage];
            }
        } else if (aquaImage) {
            [[self cell] setImage: aquaImage];
        }
    } else {
        if (clearImage) {
            [[self cell] setImage: clearImage];
        }
    }
}

static volatile BOOL registered = NO;
static volatile int cachedTint = 0;

+ (void) _controlTintChanged: (NSNotification *) note;
{
    cachedTint = 0;
}

OmniAppKit_EXTERN int OACurrentControlTint()
{
    int theTint;
    
    if (!registered) {
        /* There is a tiny, tiny race condition here, which may get us registered twice. No real harm should come of that, though. */
        registered = YES;
        [[NSNotificationCenter defaultCenter] addObserver: [OAAquaButton class]
                                                 selector: @selector(_controlTintChanged:)
                                                     name: NSControlTintDidChangeNotification
                                                   object: nil];
    }
    
    theTint = cachedTint;
    if (!theTint) {
        theTint = [[NSUserDefaults standardUserDefaults] integerForKey: @"AppleAquaColorVariant"];
        cachedTint = theTint;
    }
    
    return theTint? theTint : AQUA_TINT;
}

@end

