// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAExtendedOutlineView.h,v 1.15 2000/08/02 00:31:39 neo Exp $

#import <AppKit/NSNibDeclarations.h> // For IBOutlet
#import <AppKit/NSOutlineView.h>

@class NSPasteboard;

#import <OmniAppKit/OAFindControllerTargetProtocol.h>

@interface OAExtendedOutlineView : NSOutlineView <OAFindControllerTarget>
{
    struct {
        unsigned int isDraggingDestination:1;
        unsigned int isDraggingDestinationAcceptable:1;
        unsigned int justAcceptedDrag:1;
        unsigned int smoothExpandCollapse:1;
    } flags;
    int dragSourceRow, dragSourceLevel;
    int dragDestinationRow, dragDestinationLevel;
    
    id draggingSourceItem;
    BOOL shouldEditNextItemWhenEditingEnds;
    
    NSArray *autoExpandedItems;
}

// API
- (id)parentItemForRow:(int)row child:(unsigned int *)childIndexPointer;
- (id)parentItemForRow:(int)row indentLevel:(int)childLevel child:(unsigned int *)childIndexPointer;

- (BOOL)shouldEditNextItemWhenEditingEnds;
- (void)setShouldEditNextItemWhenEditingEnds:(BOOL)value;

- (void) setSmoothExpandCollapseEnabled: (BOOL) yn;
- (BOOL) smoothExpandCollapseEnabled;

- (void) autoExpandItems: (NSArray *) items;

- (float)rowOffset:(int)row;

// Actions
- (IBAction)expandAll:(id)sender;
- (IBAction)contractAll:(id)sender;
- (IBAction)expandSelection:(id)sender;
- (IBAction)contractSelection:(id)sender;
//
- (IBAction)copy:(id)sender;
- (IBAction)cut:(id)sender;
- (IBAction)delete:(id)sender;
- (IBAction)paste:(id)sender;


@end

@interface NSObject(OAExtendedOutlineViewDataSource)
// Implement this if you want to accept dragging in.
- (NSArray *)outlineViewAcceptedPasteboardTypes:(OAExtendedOutlineView *)outlineView;

// If you implement the above, then you MUST implement these:
- (BOOL)outlineView:(OAExtendedOutlineView *)outlineView allowPasteItemFromPasteboard:(NSPasteboard *)pasteboard parentItem:(id)parentItem child:(int)index;
- (void)outlineView:(OAExtendedOutlineView *)outlineView pasteItemFromPasteboard:(NSPasteboard *)pasteboard parentItem:(id)parentItem child:(int)index;

- (void)outlineView:(OAExtendedOutlineView *)outlineView parentItem:(id)parentItem moveChildren:(NSArray *)movingChildren toNewParentItem:(id)newParentItem;

- (void)outlineView:(OAExtendedOutlineView *)outlineView parentItem:(id)parentItem moveChildren:(NSArray *)movingChildren toNewParentItem:(id)newParentItem beforeIndex:(int)beforeIndex; // beforeIndex == -1 means add to end

// Implement this if you want find support
- (BOOL) outlineView:(OAExtendedOutlineView *)outlineView item: (id) item matchesString: (NSString *) string ignoreCase: (BOOL) ignoreCase;

// Implement this if you want to allow dragging out.
- (void)outlineView:(OAExtendedOutlineView *)outlineView copyItem:(id)item toPasteboard:(NSPasteboard *)pasteboard;
- (void)outlineView:(OAExtendedOutlineView *)outlineView deleteItem:(id)item parentItem:(id)parentItem;

- (NSUndoManager *)undoManagerForOutlineView:(OAExtendedOutlineView *)outlineView;

// When the return key is pressed, we ask the data source to create a new item
- (BOOL)outlineView:(NSOutlineView *)anOutlineView createNewItemAsChild:(int)index ofItem:(id)item;

@end
