//
// OAHierarchicalPopUpController.h
// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// Created by wiml on Tue Sep 12 2000.
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAHierarchicalPopUpController.h,v 1.1 2000/09/18 20:24:59 wiml Exp $

#import <Foundation/Foundation.h>
#import <AppKit/NSNibDeclarations.h>

@class NSPopUpButton;

@interface OAHierarchicalPopUpController : NSObject
{
    id <NSObject> target;
    SEL anAction;
    
    NSArray *structure;
    NSMutableDictionary *representedObjects;
    
    /* Managing the "recent selections" portion of the menu */
    NSString *recentSelectionsDefaultKey;  /* non-nil to store selections in defaults db */
    NSArray *recentSelectionsHeading;      /* menu tuple to insert ahead of any recent sel'ns */
    int recentSelectionsMaxCount;          /* max nr. of items in the recent stuff section */
    NSMutableArray *recentSelections;      /* LRU-ordered list of recent selections */
    
    IBOutlet NSPopUpButton *theButton;
}

/* NB The controller must be set up in a particular order. After -awakeFromnib, first -setRecentSelectionsHeading:..., then -setMenuStructure:, finally -setSelectedObject:. */

- (void)setMenuStructure:(NSArray *)newPopupStructure;
- (void)setRecentSelectionsHeading:(NSString *)heading count:(int)count defaultKey:(NSString *)key;

- (id <NSObject>)selectedObject;
- (void)setSelectedObject:(id <NSObject>)newSelection;

- (void)setTarget:(id <NSObject>)anObject;
- (void)setAction:(SEL)anAction;

/* random utility method */
+ (NSArray *)menuStructureFromDictionaries:(NSDictionary *)topDictionary subcategories:(NSArray *)subcatStrings;

@end


