// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAResizingByteFormatter.h"

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAResizingByteFormatter.m,v 1.4 2000/10/11 12:03:54 kc Exp $")

@implementation OAResizingByteFormatter

static NSString *thousandsFormats[] = {@"#,##0", @"#,##0.0 KB", @"#,##0.0 MB", @"#,##0.0 GB", @"#,##0.0 TB", @"#,##0.0 PB"};

- initWithNonretainedTableColumn:(NSTableColumn *)tableColumn;
{
    if (![super init])
        return nil;
        
    nonretainedTableColumn = tableColumn;
    return self;
}

// NSFormatter

- (NSString *)stringForObjectValue:(id)obj;
{
    unsigned int thousandsIndex;
    NSString *bytesString = @"";
    double scaledBytes;
    NSCell *dataCell = [nonretainedTableColumn dataCell];
    
    scaledBytes = [obj doubleValue];
    for (thousandsIndex = 0; thousandsIndex < sizeof(thousandsFormats); thousandsIndex++) {
        [self setFormat:thousandsFormats[thousandsIndex]];
        
        if (thousandsIndex == 0) {
            // Sadly, you can't include an 'e' in a NSNumberFormatter's format string
            bytesString = [[super stringForObjectValue:obj] stringByAppendingString:@" bytes"];
        } else {
            bytesString = [super stringForObjectValue:[NSNumber numberWithDouble:scaledBytes]];
        }
        
        if (scaledBytes < (1024 / 10)) // if our new value < (1024 / 10), we aren't going to get any skinnier
            return bytesString;
        
        if ([[dataCell font] widthOfString:bytesString] + 5.0 <= NSWidth([dataCell titleRectForBounds:NSMakeRect(0.0, 0.0, [nonretainedTableColumn width], 30.0)]))
            return bytesString;
            
        scaledBytes /= 1024.0;
    }
    
    return bytesString;
}

- (NSAttributedString *)attributedStringForObjectValue:(id)obj withDefaultAttributes:(NSDictionary *)attrs;
{
    return [[[NSAttributedString alloc] initWithString:[self stringForObjectValue:obj] attributes:attrs] autorelease];
}


- (NSString *)editingStringForObjectValue:(id)obj;
{
    return [obj stringValue];
}

- (BOOL)getObjectValue:(id *)obj forString:(NSString *)string errorDescription:(NSString **)error;
{
    *obj = [NSNumber numberWithInt:[string intValue]];
    return YES;
}

//- (BOOL)isPartialStringValid:(NSString *)partialString newEditingString:(NSString **)newString errorDescription:(NSString **)error;


@end
