// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAShrinkingTextDisplayer.h"

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <CoreGraphics/CGContext.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAShrinkingTextDisplayer.m,v 1.2 2000/10/23 20:45:18 kc Exp $")

@implementation OAShrinkingTextDisplayer

static NSFont *defaultFont;

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
	return;
    initialized = YES;
    
    defaultFont = [NSFont messageFontOfSize:13.0];
}


// API

- (void)setFont:(NSFont *)font;
{
    if (font == baseFont)
        return;
        
    [baseFont release];
    baseFont = [font retain];
    [self setNeedsDisplay:YES];
}
- (NSFont *)font;
{
    return baseFont;
}

- (void)setStringValue:(NSString *)newString;
{
    if (newString == string)
        return;
        
    [string release];
    string = [newString copy];
    [self setNeedsDisplay:YES];
}
- (NSString *)stringValue;
{
    return string;
}

// NSView

- (void)drawRect:(NSRect)rect;
{
    NSRect frame = [self frame];
    NSFont *drawFont;
    NSDictionary *drawAttributes;
    float normalStringWidth;
    NSPoint drawPoint;
    
    drawFont = baseFont;
    if (!drawFont)
        drawFont = defaultFont;

    drawAttributes = [NSDictionary dictionaryWithObjectsAndKeys:drawFont, NSFontAttributeName, [NSColor controlTextColor], NSForegroundColorAttributeName, nil];

    normalStringWidth = [string sizeWithAttributes:drawAttributes].width;
    if (normalStringWidth > NSWidth(frame)) {
        CGContextSetHorizontalTextScaling([[NSGraphicsContext currentContext] graphicsPort], 100.0 * NSWidth(frame) / normalStringWidth);
        drawPoint = NSMakePoint(0, 0);
    } else {
        drawPoint = NSMakePoint((NSWidth(frame) - normalStringWidth) / 2.0, 0);
    }
    
    [string drawAtPoint:drawPoint withAttributes:drawAttributes];
}

- (BOOL)isFlipped;
{
    return NO;
}

@end
