// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/NSMenu-OAExtensions.h>

#import <AppKit/NSScreen.h>
#import <Foundation/NSUserDefaults.h>
#import <Foundation/NSString.h>
#import <Foundation/NSArray.h>
#import <OmniBase/rcsid.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSMenu-OAExtensions.m,v 1.1 2000/11/21 03:55:47 bungi Exp $")

static NSString *OAContextMenuLayoutDefaultKey = @"ContextMenuLayout";

#define MIN_SCREEN_WIDTH (1024)


@implementation NSMenu (OAExtensions)

+ (OAContextMenuLayout) contextMenuLayoutDefaultValue;
{
    OAContextMenuLayout layout;
    
    layout = [[NSUserDefaults standardUserDefaults] integerForKey: OAContextMenuLayoutDefaultKey];
    if (layout > OAContextMenuLayoutCount)
        layout = OAAutodetectContextMenuLayout;
        
    return layout;
}

+ (void) setContextMenuLayoutDefaultValue: (OAContextMenuLayout) newValue;
{
    if (newValue > OAContextMenuLayoutCount)
        newValue = OAAutodetectContextMenuLayout;
    [[NSUserDefaults standardUserDefaults] setInteger: newValue forKey: OAContextMenuLayoutDefaultKey];
}

+ (OAContextMenuLayout) contextMenuLayoutForScreen: (NSScreen *) screen;
{
    OAContextMenuLayout layout;
    
    layout = [self contextMenuLayoutDefaultValue];
    if (layout == OAAutodetectContextMenuLayout) {
        NSRect frame;
        NSArray *screens;
        unsigned int screenIndex, screenCount;;
        
        if (screen)
            screens = [NSArray arrayWithObject: screen];
        else
            screens = [NSScreen screens];

        screenCount = [screens count];
        for (screenIndex = 0; screenIndex < screenCount; screenIndex++) {
            screen = [screens objectAtIndex: screenIndex];
            frame = [screen visibleFrame];

            if (NSWidth(frame) <= MIN_SCREEN_WIDTH)
                return OASmallContextMenuLayout;
        }
        
        return OAWideContextMenuLayout;
    }
    
    return layout;
}

@end
