// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceClient.h,v 1.13 2000/12/21 20:02:00 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSDictionary, NSNotification, NSString;
@class NSBox, NSTextField, NSView;
@class NSUserDefaults;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet

@interface OAPreferenceClient : OFObject
{
    IBOutlet NSBox *controlBox;
    IBOutlet NSView *initialFirstResponder;

    NSString *title;
    NSArray *defaultsArray; // This can actually contain any given default twice, but that has no effect right now.
    NSUserDefaults *defaults;
}

- initWithTitle:(NSString *)newTitle defaultsArray:(NSArray *)newDefaultsArray;

- (NSBox *)controlBox;
- (NSView *)initialFirstResponder;

- (void)resetFloatValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;
- (void)resetIntValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;

// This is an action, so don't change its type
- (IBAction)restoreDefaults:(id)sender;
- (void)restoreDefaultsNoPrompt;
- (BOOL)haveAnyDefaultsChanged;

- (void)pickDirectoryForTextField:(NSTextField *)textField;

// The default implementations of these methods do nothing:  each subclass is expected to implement them.
- (void)updateUI;
- (void)setValueForSender:(id)sender;
- (void)becomeCurrentPreferenceClient;
- (void)resignCurrentPreferenceClient;
    
// These are public so they can be subclassed.
- (void)valuesHaveChanged;
- (void)controlTextDidEndEditing:(NSNotification *)notification;

// NSNibAwaking informal protocol
// Be sure to call super if you subclass this.
- (void)awakeFromNib;

@end
