// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceController.h,v 1.15 2000/12/23 00:24:20 kc Exp $

#import <OmniFoundation/OFObject.h>
#import <Foundation/NSGeometry.h>

@class NSArray, NSMutableArray, NSMutableDictionary;
@class NSBox, NSButton, NSImageView, NSMatrix, NSTabView, NSTextField, NSView, NSWindow;
@class  OAPreferenceClient, OAPreferenceClientRecord, OAPreferencesIconView, OAPreferencesShowAllIconView;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet

@interface OAPreferenceController : OFObject
{
    IBOutlet NSWindow *window;
    IBOutlet NSBox *preferenceBox;
    IBOutlet OAPreferencesIconView *favoritesIconView;
    IBOutlet OAPreferencesIconView *showAllIconView;
    IBOutlet NSView *returnToOriginalValuesView;
    IBOutlet NSButton *returnToOriginalValuesButton;
    
    NSView *showAllIconsView;
    
    NSMutableArray *preferencesIconViews;
    NSMutableDictionary *categoryNamesToClientRecordsArrays;
    
    NSMutableArray *allClientRecords;

    OAPreferenceClientRecord *nonretained_currentClientRecord;
    OAPreferenceClient *nonretained_currentClient;
}

+ (OAPreferenceController *)sharedPreferenceController;

// API
- (void)close;
- (void)setTitle:(NSString *)title;
- (void)setCurrentClientByClassName: (NSString *)name;
- (NSArray *)allClientRecords;
- (OAPreferenceClientRecord *)clientRecordWithShortTitle:(NSString *)shortTitle;
- (void)iconView:(OAPreferencesIconView *)iconView buttonHitAtIndex:(unsigned int)index;

// Actions
- (IBAction)showPreferencesPanel:(id)sender;
- (IBAction)restoreDefaults:(id)sender;


@end
