// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAPreferencesFavoritesIconView.h"

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <OmniBase/rcsid.h>

#import "NSImage-OAExtensions.h"
#import "OAPreferenceClient.h"
#import "OAPreferenceClientRecord.h"
#import "OAPreferenceController.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferencesFavoritesIconView.m,v 1.2 2000/12/21 20:02:01 kc Exp $")

@interface OAPreferencesFavoritesIconView (Private)
- (void)_writeDefaults;
@end

@interface OAPoofWindow : NSWindow
@end
@implementation OAPoofWindow
- (float)_transparency {return 0.9;}
@end

@implementation OAPreferencesFavoritesIconView

static NSString *favoritePreferencesKey = @"Favorite Preferences";

// Init and dealloc

- (id)initWithFrame:(NSRect)rect;
{
    NSArray *namesArray;
    unsigned int nameIndex;

    if (![super initWithFrame:rect])
        return nil;

    favoriteClientRecords = [[NSMutableArray alloc] init];
    dropPlaceholderIndex = NSNotFound;
    
    namesArray = [[NSUserDefaults standardUserDefaults] arrayForKey:favoritePreferencesKey];
    for (nameIndex = 0; nameIndex < [namesArray count]; nameIndex++) {
        OAPreferenceClientRecord *clientRecord;
        
        clientRecord = [[OAPreferenceController sharedPreferenceController] clientRecordWithShortTitle:[namesArray objectAtIndex:nameIndex]];
        if (clientRecord != nil)
            [favoriteClientRecords addObject:clientRecord];
    }

    return self;
}

// NSView

    
- (void)drawRect:(NSRect)rect;
{
    [self _drawBackgroundForRect:rect];

    [super drawRect:rect];

    [[NSColor darkGrayColor] set];
    NSRectFill(NSMakeRect(NSMinX(_bounds), NSMinY(_bounds), 1.0, NSHeight(_bounds)));

    if (dropPlaceholderIndex != NSNotFound) {
        NSRect boundsWithoutLeftBar;
        
        boundsWithoutLeftBar = _bounds;
        boundsWithoutLeftBar.origin.x += 1.0;
        
        [[NSColor windowFrameColor] set];
        NSFrameRectWithWidth(NSInsetRect(_bounds, 1.0, 1.0), 2.0);
    }
}

- (BOOL)isOpaque;
{
    return YES;
}

- (void)awakeFromNib;
{
    [self registerForDraggedTypes:[NSArray arrayWithObject:OAPreferencesIconDragType]];
}

// NSDraggingSource
- (void)draggedImage:(NSImage *)image endedAt:(NSPoint)screenPoint deposited:(BOOL)flag;
{
    NSImage *poofImage;
    NSSize imageSize, poofImageSize;
    NSWindow *poofWindow;
    NSDate *date;
    unsigned int imageIndex;

    if (flag)
        return;
    
    if (poofImages == nil) {
        poofImages = [[NSArray alloc] initWithObjects:[NSImage imageNamed:@"poof1" inBundleForClass:isa], [NSImage imageNamed:@"poof2" inBundleForClass:isa], [NSImage imageNamed:@"poof3" inBundleForClass:isa], [NSImage imageNamed:@"poof4" inBundleForClass:isa], [NSImage imageNamed:@"poof5" inBundleForClass:isa], nil]; 
    }
    
    poofImage = [poofImages lastObject];
    poofImageSize = [poofImage size];
    imageSize = [image size];
    poofWindow = [[OAPoofWindow alloc] initWithContentRect:NSMakeRect(floor(screenPoint.x + imageSize.width / 2.0 - poofImageSize.width / 2.0), floor(screenPoint.y + imageSize.width / 2.0 - poofImageSize.height / 2.0), poofImageSize.width, poofImageSize.height) styleMask:NSBorderlessWindowMask backing:NSBackingStoreBuffered defer:NO];
    [poofWindow setLevel:NSPopUpMenuWindowLevel];
    [poofWindow setAutodisplay:NO];
    
    date = [NSDate date];
    for (imageIndex = 0; imageIndex < [poofImages count]; imageIndex++) {
        [[poofWindow contentView] lockFocus];
        [[poofImages objectAtIndex:imageIndex] compositeToPoint:NSZeroPoint operation:NSCompositeCopy];
        [[poofWindow contentView] unlockFocus];
        [poofWindow flushWindow];
        [poofWindow orderFront:nil];
        [NSThread sleepUntilDate:[date addTimeInterval:0.08 * imageIndex]];
    }
    
    [poofWindow close];
}

// NSDraggingDestination

- (unsigned int)draggingEntered:(id <NSDraggingInfo>)sender;
{
    NSPasteboard *draggingPasteboard;
    OAPreferenceClientRecord *clientRecord;

    // remove client with same name
    draggingPasteboard = [sender draggingPasteboard];
    if ([draggingPasteboard availableTypeFromArray:[NSArray arrayWithObject:OAPreferencesIconDragType]] == nil)
        return NO;
        
    clientRecord = [[OAPreferenceController sharedPreferenceController] clientRecordWithShortTitle:[draggingPasteboard stringForType:OAPreferencesIconDragType]];
    if (clientRecord != nil) {
        duplicatedDraggedClientRecordIndex = [favoriteClientRecords indexOfObject:clientRecord];
        if (duplicatedDraggedClientRecordIndex != NSNotFound) {
            duplicatedDraggedClientRecord = clientRecord;
            [favoriteClientRecords removeObjectAtIndex:duplicatedDraggedClientRecordIndex];
        }
    }

    return [self draggingUpdated:sender];
}

- (unsigned int)draggingUpdated:(id <NSDraggingInfo>)sender;
{
    NSPoint dragLocation;
    
    if ([self _numberOfIcons] >= [self _iconsWide]) {
        // We're full, so don't accept any more icons.
        dropPlaceholderIndex = NSNotFound;
    } else {
        dragLocation = [self convertPoint:[sender draggingLocation] fromView:nil];
        dropPlaceholderIndex = MIN(floor(dragLocation.x / buttonSize.width), [[self preferenceClientRecords] count]);
        [self setNeedsDisplay:YES];
    }
    
    return NSDragOperationGeneric;
}

- (void)draggingExited:(id <NSDraggingInfo>)sender;
{
    // add client with same name if we removed it in ...Entered
    if (duplicatedDraggedClientRecordIndex != NSNotFound) {
        [favoriteClientRecords insertObject:duplicatedDraggedClientRecord atIndex:duplicatedDraggedClientRecordIndex];
        
        duplicatedDraggedClientRecordIndex = NSNotFound;
        duplicatedDraggedClientRecord = nil;
    }
    
    dropPlaceholderIndex = NSNotFound;
    [self setNeedsDisplay:YES];
}

- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender;
{
    return YES;
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender;
{
    NSPasteboard *draggingPasteboard;
    OAPreferenceClientRecord *clientRecord;
    unsigned int dropIndex;
    
    dropIndex = dropPlaceholderIndex;
    dropPlaceholderIndex = NSNotFound;
    [self setNeedsDisplay:YES];

    if (dropIndex == NSNotFound)
        return NO;

    draggingPasteboard = [sender draggingPasteboard];
    if ([draggingPasteboard availableTypeFromArray:[NSArray arrayWithObject:OAPreferencesIconDragType]] == nil)
        return NO;
        
    clientRecord = [[OAPreferenceController sharedPreferenceController] clientRecordWithShortTitle:[draggingPasteboard stringForType:OAPreferencesIconDragType]];
    if (clientRecord == nil)
        return NO;
        
    [favoriteClientRecords insertObject:clientRecord atIndex:dropIndex];
    return YES;
}

- (void)concludeDragOperation:(id <NSDraggingInfo>)sender;
{
    duplicatedDraggedClientRecordIndex = NSNotFound;
    duplicatedDraggedClientRecord = nil;

    [self _writeDefaults];
}


// OAPreferencesIconView

- (NSArray *)preferenceClientRecords;
{
    return favoriteClientRecords;
}

// OAPreferencesIconView (Subclasses)

- (unsigned int)_numberOfIcons;
{
    return [[self preferenceClientRecords] count] + ((dropPlaceholderIndex == NSNotFound) ? 0 : 1);
}

- (BOOL)_isIconSelectedAtIndex:(unsigned int)index;
{
    if (index < dropPlaceholderIndex)
        return [super _isIconSelectedAtIndex:index];
    else if (index > dropPlaceholderIndex)
        return [super _isIconSelectedAtIndex:index-1];
    return NO;
}

- (BOOL)_iconImage:(NSImage **)image andName:(NSString **)name forIndex:(unsigned int)index;
{
    if (index < dropPlaceholderIndex)
        return [super _iconImage:image andName:name forIndex:index];
    else if (index > dropPlaceholderIndex)
        return [super _iconImage:image andName:name forIndex:index-1];

    // index == dropPlaceholderIndex
    *image = nil;
    *name = nil;
    return YES;
}

- (BOOL)_dragIconIndex:(unsigned int)index event:(NSEvent *)event;
{
    NSImage *iconImage;
    NSString *name;

    if (![self _iconImage:&iconImage andName:&name forIndex:index])
        return YES; // Yes, I handled your stinky bad call.
    
    pressedIconIndex = NSNotFound;
    [favoriteClientRecords removeObjectAtIndex:index];
    
    [self _dragIconImage:iconImage andName:name event:event];

    [self _writeDefaults]; // In case we dragged an icon off the dock
    return YES;
}

@end

@implementation OAPreferencesFavoritesIconView (Private)

- (void)_writeDefaults;
{
    NSMutableArray *namesArray;
    unsigned int nameIndex;

    namesArray = [NSMutableArray array];
    for (nameIndex = 0; nameIndex < [favoriteClientRecords count]; nameIndex++) {
        [namesArray addObject:[[favoriteClientRecords objectAtIndex:nameIndex] shortTitle]];
    }
    
    [[NSUserDefaults standardUserDefaults] setObject:namesArray forKey:favoritePreferencesKey];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

@end
