// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAPreferencesShowAllIconView.h"

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniBase/OmniBase.h>

#import "NSImage-OAExtensions.h"
#import "NSView-OAExtensions.h"
#import "OAPreferenceController.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferencesShowAllIconView.m,v 1.2 2000/12/21 20:02:02 kc Exp $")

@interface OAPreferencesShowAllIconView (Private)
@end

@implementation OAPreferencesShowAllIconView

static NSImage *showAllImage = nil;


// NSResponder

// NSView

- (void)drawRect:(NSRect)rect;
{
    [self _drawBackgroundForRect:rect];
    [self _drawIconAtIndex:0];
}

- (BOOL)isOpaque;
{
    return YES;
}

// OAPreferencesIconView

- (BOOL)_isIconSelectedAtIndex:(unsigned int)index;
{
    return selectedClientRecord == nil;
}

- (BOOL)_iconImage:(NSImage **)image andName:(NSString **)name forIndex:(unsigned int)index;
{
    if (!showAllImage)
        showAllImage = [[NSImage imageNamed:@"OmniPreferences" inBundleForClass:isa] retain];
        
    *image = showAllImage;
    *name = NSLocalizedStringFromTableInBundle(@"Show All", @"OmniAppKit", [self bundle], preferences panel button);
    
    return YES;
}

- (BOOL)_dragIconIndex:(unsigned int)index event:(NSEvent *)event;
{
    return NO;
}

- (unsigned int)_numberOfIcons;
{
    return 1;
}

@end

@implementation OAPreferencesShowAllIconView (Private)

@end
