// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Inspector.subproj/OAInspector.h,v 1.12 2001/02/15 15:12:31 kc Exp $

#import <OmniBase/OBObject.h>

@class NSBox, NSView, NSWindow;

#import <AppKit/NSNibDeclarations.h> // For IBOutlet
#import <OmniAppKit/OAInspectableControllerProtocol.h>
#import <OmniAppKit/OAInspectorProtocol.h>

@interface OAInspector : OBObject
{
    IBOutlet NSWindow *inspectorWindow;
    IBOutlet NSBox *inspectorBox;
    IBOutlet NSBox *noInspectorBox;
    IBOutlet NSBox *multiInspectorBox;

    id <OAInspector, NSObject> currentInspector;
    NSView *currentInspectorView;

    BOOL isOnScreen;

    id <OAInspectableController, NSObject> currentInspectableController;
    id inspectedObject;
}

+ (void)registerInspector:(id <OAInspector>)anInspector forClass:(Class)aClass;
+ (OAInspector *) sharedInspector;
+ (void)showInspector;
+ (void)updateInspector;

+ (id)multipleSelectionObject;


- (id <OAInspectableController, NSObject>)currentInspectableController;
- (id)inspectedObject;
- (BOOL)isInspectorVisible;

@end

#import <OmniAppKit/FrameworkDefines.h>

OmniAppKit_EXTERN NSString *OAInspectorSelectionDidChangeNotification;
OmniAppKit_EXTERN NSString *OAInspectorShowInspectorDefaultKey;
