// Copyright 1999-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.


#import <OmniAppKit/NSOutlineView-OAExtensions.h>

#import <OmniAppKit/NSTableView-OAExtensions.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSOutlineView-OAExtensions.m,v 1.14 2001/02/15 15:12:43 kc Exp $")

@implementation NSOutlineView (OAExtensions)

- (id)selectedItem;
{
    if ([self numberOfSelectedRows] != 1)
        return nil;

    return [self itemAtRow: [self selectedRow]];
}

- (void)setSelectedItem:(id)item;
{
    [self setSelectedItem: item visibility: OATableViewRowVisibilityLeaveUnchanged];
}

- (void)setSelectedItem:(id)item visibility:(OATableViewRowVisibility)visibility;
{
    int row;

    row = [self rowForItem:item];
    if (row == NSNotFound) {
        [self deselectAll: nil];
        return;
    }
    
    [self selectRow:row byExtendingSelection:NO];
    
    if (visibility == OATableViewRowVisibilityScrollToVisible) {
        [self scrollRowToVisible:row];
    } else if (visibility == OATableViewRowVisibilityScrollToMiddleIfNotVisible) {
#warning TJW: Finish OATableViewRowVisibilityScrollToMiddleIfNotVisible        
        [self scrollRowToVisible:row];
    }
}


- (NSArray *)selectedItems;
{
    NSMutableArray *items;
    NSEnumerator *rowEnum;
    NSNumber *row;
    
    items = [NSMutableArray array];
    rowEnum = [self selectedRowEnumerator];
    while ((row = [rowEnum nextObject]))
        [items addObject:[self itemAtRow:[row intValue]]];

    return items;
}

- (void)setSelectedItems:(NSArray *)items visibility:(OATableViewRowVisibility)visibility;
{
    NSHashTable *itemTable;
    unsigned int itemIndex, itemCount, rowIndex, rowCount;
    id item;
    BOOL shouldExtendSelection;
    
    itemCount = [items count];
    if (!itemCount)
        return;
        
    // Build a has table of the objects to select to avoid a O(N^2) loop.
    // This also uniques the list of objects nicely, should it not already be.
    itemTable = NSCreateHashTable(NSNonOwnedPointerHashCallBacks, itemCount);
    itemIndex = itemCount;
    while (itemIndex--)
        NSHashInsert(itemTable, [items objectAtIndex:itemIndex]);
        
    // Now, do a O(N) search through all of the rows and select any for which we have objects
    shouldExtendSelection = NO;
    rowCount = [self numberOfRows];
    for (rowIndex = 0; rowIndex < rowCount; rowIndex++) {
        item = [self itemAtRow:rowIndex];
        if (NSHashGet(itemTable, item)) {
            // We should be able to always extend the selection, since we deselected everything above. However, as of OS X DP4, if we do that, it sometimes triggers an assertion and NSLog in NSTableView. (Usually that happens after dragging an item.)
            [self selectRow:rowIndex byExtendingSelection:shouldExtendSelection];
            shouldExtendSelection = YES;
        }
    }

    // If nothing ended up getting selected, clear the selection
    if (!shouldExtendSelection)
        [self deselectAll:nil];

    NSFreeHashTable(itemTable);
     
    [self scrollSelectedRowsToVisibility: visibility];
}

- (void)setSelectedItems:(NSArray *)items;
{
    [self setSelectedItems: items visibility: OATableViewRowVisibilityLeaveUnchanged];
}

- (id) firstItem;
{
    unsigned int count;
    
    count = [_dataSource outlineView: self numberOfChildrenOfItem: nil];
    if (!count)
        return nil;
    return [_dataSource outlineView: self child: 0 ofItem: nil];
}

- (void)expandAllItemsAtLevel:(unsigned int)level;
{
    unsigned int rowCount, rowIndex;
    
    rowCount = [self numberOfRows];
    for (rowIndex = 0; rowIndex < rowCount; rowIndex++) {
        if ([self levelForRow: rowIndex] == level) {
            id item;
            
            item = [self itemAtRow: rowIndex];
            if ([self isExpandable: item] && ![self isItemExpanded: item]) {
                [self expandItem: item];
                rowCount = [self numberOfRows];
            }
        }
    }
}


@end
