// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceClientRecord.h,v 1.14 2001/02/21 07:42:42 rick Exp $

#import <OmniFoundation/OFObject.h>

@class NSArray, NSDictionary;
@class NSImage;
@class OAPreferenceClient, OAPreferenceController;

@interface OAPreferenceClientRecord : OFObject
{
    NSString     *categoryName;
    NSString     *className;
    NSString     *title;
    NSString     *shortTitle;
    NSString     *iconName;
    NSString     *nibName;
    NSString	 *helpURL;
    NSDictionary *defaultsDictionary;
    NSArray      *defaultsArray;

    NSImage      *iconImage;
    
    OAPreferenceClient *clientInstance;
}

- (id)initWithCategoryName:(NSString *)newName;
    // Designated initializer.

- (NSImage *)iconImage;

- (NSString *)categoryName;
- (NSString *)className;
- (NSString *)title;
- (NSString *)shortTitle;
- (NSString *)iconName;
- (NSString *)nibName;
- (NSString *)helpURL;
- (NSDictionary *)defaultsDictionary;
- (NSArray *)defaultsArray;

- (void)setClassName:(NSString *)newClassName;
- (void)setTitle:(NSString *)newTitle;
- (void)setShortTitle:(NSString *)newShortTitle;
- (void)setIconName:(NSString *)newIconName;
- (void)setNibName:(NSString *)newNibName;
- (void)setHelpURL:(NSString *)newHelpURL;
- (void)setDefaultsDictionary:(NSDictionary *)newDefaultsDictionary;
- (void)setDefaultsArray:(NSArray *)newDefaultsArray;

- (NSComparisonResult)compare:(OAPreferenceClientRecord *)other;

- (OAPreferenceClient *) clientInstanceInController: (OAPreferenceController *) controller;


@end
