// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAChasingArrowsProgressIndicator.h"

#import <Cocoa/Cocoa.h>
#import <ApplicationServices/ApplicationServices.h>
#import <OmniBase/OmniBase.h>

#import "NSImage-OAExtensions.h"


RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAChasingArrowsProgressIndicator.m,v 1.6 2001/02/15 15:12:55 kc Exp $")

@interface OAChasingArrowsProgressIndicator (Private)
@end

#define FRAMES_PER_CYCLE  (16)
#define CYCLES_PER_SECOND (1.0)

#define FRAMES_PER_SECOND ((float)(FRAMES_PER_CYCLE * CYCLES_PER_SECOND))

static NSImage *chasingArrows = nil;

@implementation OAChasingArrowsProgressIndicator

+ (void) initialize;
{
    OBINITIALIZE;
    
    chasingArrows = [[NSImage imageNamed:@"OAChasingArrows" inBundleForClass:self] retain];
}

// Init and dealloc

- initWithFrame:(NSRect)newFrame;
{
    if (![super initWithFrame:newFrame])
        return nil;
        
    [self setIndeterminate:YES];
    [self setAnimationDelay:1.0 / FRAMES_PER_SECOND];
    
    return self;
}

// NSView

- (BOOL)isFlipped;
{
    return NO;
}

- (void)drawRect:(NSRect)rect;
{
    float angle;
    CGContextRef graphicsContext;
    NSRect bounds;

    if (!animating)
        return;
    
    counter++;
    angle = ((counter % FRAMES_PER_CYCLE) / (float)FRAMES_PER_CYCLE)  * (2.0 * M_PI);
    bounds = [self bounds];
    
    graphicsContext = (CGContextRef)[[NSGraphicsContext currentContext] graphicsPort];
    CGContextSaveGState(graphicsContext);

    CGContextTranslateCTM(graphicsContext, NSWidth(bounds) / 2.0, NSHeight(bounds) / 2.0);
    CGContextRotateCTM(graphicsContext, -angle);
    CGContextTranslateCTM(graphicsContext, -NSWidth(bounds) / 2.0, -NSHeight(bounds) / 2.0);
    
    [chasingArrows drawInRect:[self bounds] fromRect:NSZeroRect operation:NSCompositeSourceOver fraction:1.0];

    CGContextRestoreGState(graphicsContext);
}

- (BOOL)isOpaque;
{
    return NO;
}

// NSProgressIndicator

- (void)startAnimation:(id)sender;
{
    animating = YES;
    [super startAnimation:sender];
}

- (void)stopAnimation:(id)sender;
{
    animating = NO;
    [super stopAnimation:sender];
    [self setNeedsDisplay:YES];
}


- (void)animate:(id)sender;
{
    [super animate:sender];
}


@end

@implementation OAChasingArrowsProgressIndicator (Private)
@end
