// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OADockStatusItem.h,v 1.4 2001/02/15 22:51:15 kc Exp $

#import <Foundation/NSObject.h>

@class NSColor, NSImage;

#import <Foundation/NSGeometry.h>

@interface OADockStatusItem : NSObject 
{
    NSPoint position;
    NSImage *icon;
    NSColor *textColor;
    NSColor *textBackgroundColor;
    unsigned int count;
    BOOL isHidden;
}

- initWithIcon:(NSImage *)icon andTextColor:(NSColor *)color atPosition:(NSPoint)position;

- (void)setTextBackgroundColor:(NSColor *)aTextBackgroundColor;

- (void)setCount:(unsigned int)aCount;
- (void)setNoCount;

- (void)hide;
- (void)show;

- (BOOL)isHidden;

@end
