// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OATextWithIconCell.h"

#import <Cocoa/Cocoa.h>
#import <OmniBase/rcsid.h>

#import "NSImage-OAExtensions.h"
#import "NSAttributedString-OAExtensions.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OATextWithIconCell.m,v 1.3 2001/03/05 07:33:18 toon Exp $");

@interface OATextWithIconCell (Private)
@end

@implementation OATextWithIconCell

// Init and dealloc

- init;
{
    if (![super initTextCell:@""])
        return nil;
    [self setEditable:YES];
    [self setLeaf:YES];
    return self;
}

- (void)dealloc;
{
    [super dealloc];
}


// API


// NSCell Subclass

- (void)drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView *)controlView;
{
    NSImage *image;
    NSAttributedString *label;
    NSRect imageRect;
    NSRect textRect;

#define LEFT_BORDER 1.0    
    cellFrame.origin.x += LEFT_BORDER;
    cellFrame.size.width -= LEFT_BORDER;
    
    NSDivideRect(cellFrame, &imageRect, &textRect, NSHeight(cellFrame), NSMinXEdge);
    imageRect = NSInsetRect(imageRect, 0.5, 0.5);
    textRect = NSInsetRect(textRect, 1.0, -1.0);
    
    label = [self attributedStringValue];
    [label drawInRectangle:textRect alignment:NSLeftTextAlignment verticallyCentered:YES];
    
    image = [self image];
    [image drawFlippedInRect:imageRect operation:NSCompositeSourceOver];
}

@end

@implementation OATextWithIconCell (NotificationsDelegatesDatasources)
@end

@implementation OATextWithIconCell (Private)
@end
