// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/OAAppkitQueueProcessor.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "NSView-OAExtensions.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OAAppkitQueueProcessor.m,v 1.19 2001/02/15 15:12:28 kc Exp $")


@implementation OAAppkitQueueProcessor

// Give UI events priority over queued messages

- (BOOL)shouldProcessQueueEnd;
{
    NSEvent *event;

    [NSView performDeferredScrolling];
    [[NSThread currentThread] yield];
    event = [NSApp nextEventMatchingMask:NSAnyEventMask untilDate:[NSDate distantPast] inMode:NSEventTrackingRunLoopMode dequeue:NO];
    if (event) {
        if (OFQueueProcessorDebug)
            NSLog(@"%@: breaking for event: %@", OBShortObjectDescription(self), event);
        return YES;
    }
    return NO;
}

@end

//
// Override key methods in OFRunLoopQueueProcessor to get the correct AppKit
// behaviour.
//
@implementation OFRunLoopQueueProcessor (OFAppkitQueueProcessor)

+ (NSArray *) mainThreadRunLoopModes;
{
    return [NSArray arrayWithObjects: NSDefaultRunLoopMode, NSModalPanelRunLoopMode, nil];
}

+ (Class) mainThreadRunLoopProcessorClass;
{
    return [OAAppkitQueueProcessor class];
}

@end
