// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OAFindControllerTargetProtocol.h,v 1.10 2001/02/15 15:12:29 kc Exp $

#import <Foundation/NSObject.h>

@class NSView;
@class NSString;

@protocol OAFindControllerTarget
- (BOOL)findString:(NSString *)textPattern ignoreCase:(BOOL)ignoreCase backwards:(BOOL)backwards wrap:(BOOL)wrap;
@end

@interface NSObject (OAOptionalSelectedStringForFinding)
- (NSString *)selectedString;
@end

@interface NSObject (OAFindControllerAware)
- (id <OAFindControllerTarget>)omniFindControllerTarget;
@end

@protocol OASearchableContent
- (BOOL)findString:(NSString *)textPattern ignoreCase:(BOOL)ignoreCase backwards:(BOOL)backwards ignoreSelection:(BOOL)ignoreSelection;
@end

@interface NSObject (OAOptionalSearchableCellProtocol)
- (NSView <OASearchableContent> *)searchableContentView;
@end
