// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSScrollView-OAExtensions.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import "NSView-OAExtensions.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSScrollView-OAExtensions.m,v 1.10 2001/02/15 15:12:44 kc Exp $")

@implementation NSScrollView (OAExtensions)

- (void)freeGStates;
{
    [self releaseGState];
    [[self contentView] releaseGState];
}

// Overrides of NSView (OAExtensions)

- (void)scrollToTop;
{
    [[self documentView] scrollToTop];
}

- (void)scrollToEnd;
{
    [[self documentView] scrollToEnd];
}

- (void)scrollDownByPages:(float)pagesToScroll;
{
    [[self documentView] scrollDownByPages:pagesToScroll];
}

- (void)scrollDownByLines:(float)linesToScroll;
{
    [[self documentView] scrollDownByLines:linesToScroll];
}

- (void)scrollDownByPercentage:(float)percentage;
{
    [[self documentView] scrollDownByPercentage:percentage];
}

- (void)scrollDownByAdjustedPixels:(float)pixels;
{
    [[self documentView] scrollDownByAdjustedPixels:pixels];
}


- (void)scrollRightByPages:(float)pagesToScroll;
{
    [[self documentView] scrollRightByPages:pagesToScroll];
}

- (void)scrollRightByLines:(float)linesToScroll;
{
    [[self documentView] scrollRightByLines:linesToScroll];
}

- (void)scrollRightByPercentage:(float)percentage;
{
    [[self documentView] scrollRightByPercentage:percentage];
}

- (void)scrollRightByAdjustedPixels:(float)pixels;
{
    [[self documentView] scrollRightByAdjustedPixels:pixels];
}

- (float)fraction;
{
    return [[self documentView] fraction];
}

- (void)setFraction:(float)fraction;
{
    [[self documentView] setFraction:fraction];
}

@end
