// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/OAPreferenceClient.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OmniAppKit/OAPreferenceController.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferenceClient.m,v 1.14 2001/02/15 15:12:50 kc Exp $")

@implementation OAPreferenceClient

/*" Creates a new preferences client (with the specified title), which manipulates the specified defaults. "*/
- initWithTitle:(NSString *)newTitle defaultsArray:(NSArray *)newDefaultsArray;
{
    if (![super init])
	return nil;

    title = [newTitle copy];
    defaultsArray = [newDefaultsArray retain];
    defaults = [NSUserDefaults standardUserDefaults];
    return self;
}


// API

/*" The controlBox outlet points to the box that will be transferred into the Preferences window when this preference client is selected. "*/
- (NSBox *)controlBox;
{
    return controlBox;
}

- (NSView *)initialFirstResponder;
{
    return initialFirstResponder;
}

/*" Restores all defaults for this preference client to their original installation values. "*/
- (IBAction)restoreDefaults:(id)sender;
{
    switch (NSRunInformationalAlertPanelRelativeToWindow(NSLocalizedStringFromTableInBundle(@"Restore Defaults", @"OmniAppKit", [self bundle], title of alert panel), NSLocalizedStringFromTableInBundle(@"Are you sure you wish to return all the %@ preferences to their original installation values?", @"OmniAppKit", [self bundle], alert panel message), NSLocalizedStringFromTableInBundle(@"Restore", @"OmniAppKit", [self bundle], alert panel button), NSLocalizedStringFromTableInBundle(@"Cancel", @"OmniAppKit", [self bundle], alert panel button), nil, [controlBox window], title)) {
        case NSAlertDefaultReturn:
            break;
        case NSAlertAlternateReturn:
        case NSAlertOtherReturn:
            return;
            break;
    }

    [self restoreDefaultsNoPrompt];
    [self valuesHaveChanged];
}

- (void)restoreDefaultsNoPrompt;
{
    NSEnumerator *defaultEnumerator;
    NSString *defaultName;

    defaultEnumerator = [defaultsArray objectEnumerator];
    while ((defaultName = [defaultEnumerator nextObject]))
	[defaults removeObjectForKey:defaultName];
}

- (BOOL)haveAnyDefaultsChanged;
{
    NSDictionary *registrationDictionary;
    NSEnumerator *defaultEnumerator;
    NSString *defaultName;

    registrationDictionary = [defaults volatileDomainForName:NSRegistrationDomain];

    defaultEnumerator = [defaultsArray objectEnumerator];
    while ((defaultName = [defaultEnumerator nextObject])) {
        id newValue, registrationValue;
        
        newValue = [defaults objectForKey:defaultName];
        if (newValue == nil)
            continue;
        registrationValue = [registrationDictionary objectForKey:defaultName];
        if (registrationValue == nil)
            continue; // bogus default was set
        if (![newValue isEqual:registrationValue])
            return YES;
    }
    return NO;
}

/*" Prompts the user for a directory (using an open panel), then updates the text field to display it and calls -setValueForSender: specifying that field as the sender. "*/
- (void)pickDirectoryForTextField:(NSTextField *)textField;
{
    NSOpenPanel *openPanel;
    NSString *directory;

    openPanel = [NSOpenPanel new];
    [openPanel setCanChooseDirectories:YES];
    if ([openPanel runModalForTypes:nil] != NSOKButton)
	return;
    
    directory = [[openPanel filenames] objectAtIndex: 0];
    [textField setStringValue:directory];
    [self setValueForSender:textField];
}

- (void)resetFloatValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;
{
    [defaults removeObjectForKey:defaultName];
    [textField setFloatValue:[defaults floatForKey:defaultName]];
    NSBeep();
}

- (void)resetIntValueToDefaultNamed:(NSString *)defaultName inTextField:(NSTextField *)textField;
{
    [defaults removeObjectForKey:defaultName];
    [textField setIntValue:[defaults integerForKey:defaultName]];
    NSBeep();
}


// Subclass me!

/*" Updates the UI to reflect the current defaults. "*/
- (void)updateUI;
{
}

/*" Updates defaults for a modified UI element (the sender). "*/
- (void)setValueForSender:(id)sender;
{
}

/*" Called when the receiver is about to become the current client.  This can be used to register for notifications used to update the UI for the client. "*/
- (void)becomeCurrentPreferenceClient;
{
}

/*" Called when the receiver is about to give up its status as the current client.  This can be used to deregister for notifications used to update the UI for the client. "*/
- (void)resignCurrentPreferenceClient;
{
}

/*" This method should be called whenever a default is changed programmatically.  The default implementation simply calls -updateUI. "*/
- (void)valuesHaveChanged;
{
    [self updateUI];
    [defaults synchronize];
}

 // Text delegate methods
 // (We have to be the field's text delegate because otherwise the field will just silently take the value if the user hits tab, and won't set the associated preference.)

/*" The default implementation calls -setValueForSender:, setting the sender to be the notification object (i.e., the text field). "*/
- (void)controlTextDidEndEditing:(NSNotification *)notification;
{
    [self setValueForSender:[notification object]];
}


// NSNibAwaking informal protocol

/*" Be sure to call super if you subclass this "*/
- (void)awakeFromNib;
{
    [controlBox retain];
}


@end
