// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAPreferencesMultipleIconView.h"

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniBase/rcsid.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/OAPreferencesMultipleIconView.m,v 1.2 2001/06/09 01:50:58 rick Exp $");

@interface OAPreferencesMultipleIconView (Private)
@end

@implementation OAPreferencesMultipleIconView

// OAPreferencesIconView subclass

- (BOOL)isOpaque;
{
    return YES;
}

- (void)drawRect:(NSRect)aRect;
{
    [[NSColor whiteColor] set];
    NSRectFill(aRect);
    
    [[NSColor grayColor] set];
    NSRectFill(NSMakeRect(NSMinX([self bounds]), NSMaxY([self bounds]) - 1.0, NSWidth([self bounds]), 1.0));
    [super drawRect:aRect];
}

- (BOOL)_dragIconIndex:(unsigned int)index event:(NSEvent *)event;
{
    return NO;
}

@end

@implementation OAPreferencesMultipleIconView (NotificationsDelegatesDatasources)
@end

@implementation OAPreferencesMultipleIconView (Private)
@end
