// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OACarbonControlView.h"

// Problems:
//     Doesn't display initially
//     I can't get default mouse tracking to work hence the mouse down
//     Slight glitches on live resize
//     May leave crap on screen if you quit without closing window

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <Carbon/Carbon.h>
#import <OmniBase/rcsid.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OACarbonControlView.m,v 1.5 2001/02/15 15:12:54 kc Exp $")

#define _control ((ControlRef)_controlRef)

@interface OACarbonControlView (Private)
- (ControlRef)controlRef;
- (void)_setControlRef:(ControlRef)newControlRef;
- (void)adjustControlBounds;
- (void)setNeedsControlBoundsAdjust;
@end

@interface NSWindow(CarbonControl)
- (WindowRef)_windowRef;
@end

@interface NSView(OACarbonControlView)
- (void)_setUsesQuickdraw:(BOOL)usesQD;
- (Rect)_convertToQDRect:(NSRect)rect;
- (NSRect)_convertToNSRect:(Rect)qdRect;
- _invalidateGStatesForTree;
@end

@interface NSEvent(CarbonControl)
- (EventRef)_eventRef;
@end

@implementation OACarbonControlView

- (void)dealloc;
{
    [self setControlRef:NULL];
    [super dealloc];
}

// API

- (const void *)qdBounds;
{
    static Rect qdBounds;

    qdBounds = [self _convertToQDRect:[self bounds]];
    return &qdBounds;
}

- (void)setControlRef:(void *)newControlRef;
{
    [self _setControlRef:newControlRef];
}

// NSView subclass

- (void)drawRect:(NSRect)rect;
{
    [[NSColor blackColor] set];
    NSRectFill(rect);

    // QD port & clip have already been setup
    //
    if (_control != NULL) {
        if (_adjustBounds) {
            [self adjustControlBounds];
        }
        Draw1Control(_control);
    }
}

- (void)setFrameSize:(NSSize)size;
{
    [super setFrameSize:size];
    [self setNeedsControlBoundsAdjust];
}

- (void)setFrameOrigin:(NSPoint)origin;
{
    [super setFrameOrigin:origin];
    [self setNeedsControlBoundsAdjust];
}

- _invalidateGStatesForTree;
{
    [self setNeedsControlBoundsAdjust];
    return [super _invalidateGStatesForTree];
}

//_________________________________________________________________________________________
- (void)mouseDown:(NSEvent*)event;
{
    [super mouseDown:event];
    if (_control != NULL) {
        Point startPoint;
        GetEventParameter([event _eventRef], kEventParamMouseLocation, 
                        typeQDPoint, NULL, sizeof(Point),
                        NULL, &startPoint);
        SetPortWindowPort(GetControlOwner(_control));
        GlobalToLocal(&startPoint);
        TrackControl(_control, startPoint, NULL /*actionProc*/);

        // TJW: Adding this since Java wasn't redisplaying correclty after an event
        [self setNeedsDisplay: YES];
    }
}

//_________________________________________________________________________________________
// Test Test Test Test Test Test
- (void)awakeFromNib;
{
    if ([self controlRef] == NULL) {
        ControlRef control;
        Rect qdBounds;
        OSErr err;

        qdBounds = [self _convertToQDRect:[self bounds]];
        err = CreatePushButtonControl([[self window] _windowRef], &qdBounds, (CFStringRef)@"Hello!", &control);
        if (err != noErr)
            NSLog(@"Error creating control: %d", err);
        [self setControlRef:control];
    }
}

@end

@implementation OACarbonControlView (Private)

- (ControlRef)controlRef;
{
    return _control;
}

- (void)_setControlRef:(ControlRef)newControlRef;
{
    if (newControlRef != _control) {

        // get rid of old control
        //
        if (_control != NULL) {
            DisposeControl(_control);
            _control = NULL;
        }
        
        // save new control
        //
        _control = newControlRef;
        
        // set/clear flag to indicate we need special handling
        //
        [self _setUsesQuickdraw:_control != NULL];

        // place in our window and adjust position and size to match view
        //
        if (_control != NULL) {
            if (GetControlOwner(_control) != [[self window] _windowRef]) {
                AutoEmbedControl(_control, [[self window] _windowRef]);
            }
            [self setNeedsControlBoundsAdjust];
        }

        // and redraw
        //
        [self setNeedsDisplay:YES];
    }
}

- (void)adjustControlBounds;
{
    if (_control != NULL && _adjustBounds) {
        Rect qdBounds = [self _convertToQDRect:[self bounds]];
        MoveControl(_control, qdBounds.left, qdBounds.top);
        SizeControl(_control, qdBounds.right - qdBounds.left, qdBounds.bottom - qdBounds.top);
        _adjustBounds = NO;
    }
}

- (void)setNeedsControlBoundsAdjust;
{
    _adjustBounds = YES;
}

@end
