// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Carbon/OAAppleScript.h,v 1.1.4.1 2001/08/22 04:13:25 rick Exp $

#import <Foundation/NSObject.h>
#import <Carbon/Carbon.h>

@interface OAAppleScript : NSObject
{
    NSString          *_scriptString;
    OSAID              _scriptId;
}

- initWithScriptString: (NSString *) scriptString;
- (NSString *) execute;

// Utility methods build on OAAppleScript
+ (NSString *) executeScriptString: (NSString *) scriptString;

+ (void) sendMailTo:(NSString *) receiver
         carbonCopy:(NSString *) carbonCopy
            subject:(NSString *) subject
               body:(NSString *) body;
@end
