// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSColor-OAExtensions.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSColor-OAExtensions.m,v 1.3 2001/02/15 15:12:34 kc Exp $")

@implementation NSColor (OAExtensions)

+ (NSColor *)colorFromPropertyListRepresentation:(NSDictionary *)dict;
{
    id obj;
    id obj1, obj2, obj3;
    
    obj = [dict objectForKey:@"w"];
    if (obj) {
        return [NSColor colorWithCalibratedWhite:[obj floatValue] alpha:1.0];
    }
    obj = [dict objectForKey:@"catalog"];
    if (obj) {
        NSColor *color;
        obj1 = [dict objectForKey:@"name"];
        color = [NSColor colorWithCatalogName:obj colorName:obj1];
        if (!color) {
            return [NSColor whiteColor];
        }
    }
    obj = [dict objectForKey:@"r"];
    if (obj) {
        obj1 = [dict objectForKey:@"g"];
        obj2 = [dict objectForKey:@"b"];
        return [NSColor colorWithCalibratedRed:[obj floatValue] green:[obj1 floatValue] blue:[obj2 floatValue] alpha:1.0];
    }
    obj = [dict objectForKey:@"c"];
    if (obj) {
        obj1 = [dict objectForKey:@"m"];
        obj2 = [dict objectForKey:@"y"];
        obj3 = [dict objectForKey:@"k"];
        return [NSColor colorWithDeviceCyan:[obj floatValue] magenta:[obj1 floatValue] yellow:[obj2 floatValue] black:[obj3 floatValue] alpha:1.0];

    }
    return [NSColor whiteColor];
}

- (NSDictionary *)propertyListRepresentation;
{
    NSMutableDictionary *dict;
    NSString *colorSpace;
    
    dict = [NSMutableDictionary dictionary];
    colorSpace = [self colorSpaceName];
    if ([colorSpace isEqualToString:NSCalibratedWhiteColorSpace] || 
        [colorSpace isEqualToString:NSDeviceWhiteColorSpace]) {
        [dict setObject:[NSString stringWithFormat:@"%g", [self whiteComponent]] forKey:@"w"];
    } else if ([colorSpace isEqualToString:NSCalibratedRGBColorSpace] ||
               [colorSpace isEqualToString:NSDeviceRGBColorSpace]) {
        [dict setObject:[NSString stringWithFormat:@"%g", [self redComponent]] forKey:@"r"];
        [dict setObject:[NSString stringWithFormat:@"%g", [self greenComponent]] forKey:@"g"];
        [dict setObject:[NSString stringWithFormat:@"%g", [self blueComponent]] forKey:@"b"];
    } else if ([colorSpace isEqualToString:NSNamedColorSpace]) {
        [dict setObject:[self catalogNameComponent] forKey:@"catalog"];
        [dict setObject:[self colorNameComponent] forKey:@"name"];
    } else if ([colorSpace isEqualToString:NSDeviceCMYKColorSpace]) {
        [dict setObject:[NSString stringWithFormat:@"%g", [self cyanComponent]] forKey:@"c"];
        [dict setObject:[NSString stringWithFormat:@"%g", [self magentaComponent]] forKey:@"m"];
        [dict setObject:[NSString stringWithFormat:@"%g", [self yellowComponent]] forKey:@"y"];
        [dict setObject:[NSString stringWithFormat:@"%g", [self blackComponent]] forKey:@"k"];
    }
    
    return dict;
}

@end
