// Copyright 1997-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/NSFont-OAExtensions.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSFont-OAExtensions.m,v 1.7 2001/02/15 15:12:36 kc Exp $")

@implementation NSFont (OAExtensions)

- (BOOL)isScreenFont;
{
    return [self screenFont] == self;
}

- (float)widthOfString:(NSString *)aString;
{
    static NSTextStorage *fontWidthTextStorage = nil;
    static NSLayoutManager *fontWidthLayoutManager = nil;
    static NSTextContainer *fontWidthTextContainer = nil;

    NSAttributedString *attributedString;
    NSRange drawGlyphRange;
    NSRect *rectArray;
    unsigned int rectCount;
    NSDictionary *attributes;

    if (!fontWidthTextStorage) {
        fontWidthTextStorage = [[NSTextStorage alloc] init];

        fontWidthLayoutManager = [[NSLayoutManager alloc] init];
        [fontWidthTextStorage addLayoutManager:fontWidthLayoutManager];

        fontWidthTextContainer = [[NSTextContainer alloc] initWithContainerSize:NSMakeSize(1e7, 1e7)];
        [fontWidthTextContainer setLineFragmentPadding:0];
        [fontWidthLayoutManager addTextContainer:fontWidthTextContainer];
    }

    attributes = [[NSDictionary alloc] initWithObjectsAndKeys: self, NSFontAttributeName, nil];
    attributedString = [[NSAttributedString alloc] initWithString:aString attributes:attributes];
    [fontWidthTextStorage setAttributedString:attributedString];
    [attributedString release];
    [attributes release];

    drawGlyphRange = [fontWidthLayoutManager glyphRangeForTextContainer:fontWidthTextContainer];
    if (drawGlyphRange.length == 0)
        return 0.0;

    rectArray = [fontWidthLayoutManager rectArrayForGlyphRange:drawGlyphRange withinSelectedGlyphRange:NSMakeRange(NSNotFound, 0) inTextContainer:fontWidthTextContainer rectCount:&rectCount];
    if (rectCount < 1)
        return 0.0;
    return rectArray[0].size.width;
}

@end
