// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAPreferencesFavoritesIconView.h"

#import <AppKit/AppKit.h>
#import <Foundation/Foundation.h>
#import <OmniBase/rcsid.h>
#import <OmniFoundation/OmniFoundation.h>

#import "NSImage-OAExtensions.h"
#import "OAPreferenceClient.h"
#import "OAPreferenceClientRecord.h"
#import "OAPreferenceController.h"

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Preferences.subproj/Attic/OAPreferencesFavoritesIconView.m,v 1.5.6.2 2001/06/22 23:52:39 rick Exp $")

@interface OAPreferencesFavoritesIconView (Private)
- (void)_writeDefaults;
@end

@implementation OAPreferencesFavoritesIconView

static NSString *favoritePreferencesKey = @"Favorite Preferences";

// Init and dealloc

- (id)initWithFrame:(NSRect)rect;
{
    NSArray *identifiersArray;
    unsigned int identifierIndex, identifierCount;

    if (![super initWithFrame:rect])
        return nil;

    favoriteClientRecords = [[NSMutableArray alloc] init];
    dropPlaceholderIndex = NSNotFound;
    
    identifiersArray = [[NSUserDefaults standardUserDefaults] arrayForKey:favoritePreferencesKey];
    identifierCount = [identifiersArray count];
    for (identifierIndex = 0; identifierIndex < identifierCount; identifierIndex++) {
        OAPreferenceClientRecord *clientRecord;
        
        clientRecord = [[OAPreferenceController sharedPreferenceController] clientRecordWithIdentifier:[identifiersArray objectAtIndex:identifierIndex]];
        if (clientRecord != nil)
            [favoriteClientRecords addObject:clientRecord];
    }

    return self;
}

// NSView

    
- (void)drawRect:(NSRect)rect;
{
    NSBezierPath *dottedLinePath;
    float lineDash[2] = {1.0, 2.0};

    [super drawRect:rect];

    //dotted line along the left of the favorites view
    [[NSColor grayColor] set];
    dottedLinePath = [NSBezierPath bezierPath];
    [dottedLinePath moveToPoint:NSMakePoint(NSMinX(_bounds) + 0.5, NSMinY(_bounds) + 3.0)];
    [dottedLinePath lineToPoint:NSMakePoint(NSMinX(_bounds) + 0.5, NSMaxY(_bounds) - 3.0)];
    [dottedLinePath setLineWidth:1.0];
    [dottedLinePath setLineDash:lineDash count:2 phase:0];
    [dottedLinePath stroke];
}

- (BOOL)isOpaque;
{
    return NO;
}

- (void)viewDidMoveToSuperview;
{
    [self registerForDraggedTypes:[NSArray arrayWithObject:OAPreferencesIconDragType]];
}

// NSDraggingSource

- (void)draggedImage:(NSImage *)image endedAt:(NSPoint)screenPoint operation:(NSDragOperation)operation;
{
    NSImage *poofImage;
    NSSize imageSize, poofImageSize;
    NSWindow *poofWindow;
    NSDate *date;
    unsigned int imageIndex;

    if (operation != NSDragOperationNone)
        return;
    
    if (poofImages == nil) {
        poofImages = [[NSArray alloc] initWithObjects:[NSImage imageNamed:@"poof1" inBundleForClass:isa], [NSImage imageNamed:@"poof2" inBundleForClass:isa], [NSImage imageNamed:@"poof3" inBundleForClass:isa], [NSImage imageNamed:@"poof4" inBundleForClass:isa], [NSImage imageNamed:@"poof5" inBundleForClass:isa], nil]; 
    }
    
    poofImage = [poofImages lastObject];
    poofImageSize = [poofImage size];
    imageSize = [image size];
    poofWindow = [[NSWindow alloc] initWithContentRect:NSMakeRect(floor(screenPoint.x + imageSize.width / 2.0 - poofImageSize.width / 2.0), floor(screenPoint.y + imageSize.width / 2.0 - poofImageSize.height / 2.0), poofImageSize.width, poofImageSize.height) styleMask:NSBorderlessWindowMask backing:NSBackingStoreBuffered defer:NO];
    [poofWindow setLevel:NSPopUpMenuWindowLevel];
    [poofWindow setOpaque:NO];
    [poofWindow setAutodisplay:NO];
    
    date = [NSDate date];
    for (imageIndex = 0; imageIndex < [poofImages count]; imageIndex++) {
        [[poofWindow contentView] lockFocus];
        [[poofImages objectAtIndex:imageIndex] drawAtPoint:NSMakePoint(0, 0) fromRect:NSZeroRect operation:NSCompositeCopy fraction:1.0];
        [[poofWindow contentView] unlockFocus];
        [poofWindow flushWindow];
        [poofWindow orderFront:nil];
        [NSThread sleepUntilDate:[date addTimeInterval:0.08 * imageIndex]];
    }
    
    [poofWindow close];
}

// NSDraggingDestination

- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)sender;
{
    NSPasteboard *draggingPasteboard;
    OAPreferenceClientRecord *clientRecord;

    // remove client with same name
    draggingPasteboard = [sender draggingPasteboard];
    if ([draggingPasteboard availableTypeFromArray:[NSArray arrayWithObject:OAPreferencesIconDragType]] == nil)
        return NO;
        
    clientRecord = [[OAPreferenceController sharedPreferenceController] clientRecordWithShortTitle:[draggingPasteboard stringForType:OAPreferencesIconDragType]];
    if (clientRecord != nil) {
        duplicatedDraggedClientRecordIndex = [favoriteClientRecords indexOfObject:clientRecord];
        if (duplicatedDraggedClientRecordIndex != NSNotFound) {
            duplicatedDraggedClientRecord = clientRecord;
            [favoriteClientRecords removeObjectAtIndex:duplicatedDraggedClientRecordIndex];
        }
    }

    return [self draggingUpdated:sender];
}

- (NSDragOperation)draggingUpdated:(id <NSDraggingInfo>)sender;
{
    NSPoint dragLocation;
    
    if ([self _numberOfIcons] >= [self _iconsWide]) {
        // We're full, so don't accept any more icons.
        dropPlaceholderIndex = NSNotFound;
    } else {
        dragLocation = [self convertPoint:[sender draggingLocation] fromView:nil];
        dropPlaceholderIndex = MIN(floor(dragLocation.x / buttonSize.width), [[self preferenceClientRecords] count]);
        [self setNeedsDisplay:YES];
    }
    
    return NSDragOperationMove;
}

- (void)draggingExited:(id <NSDraggingInfo>)sender;
{
    // add client with same name if we removed it in ...Entered
    if (duplicatedDraggedClientRecordIndex != NSNotFound) {
        [favoriteClientRecords insertObject:duplicatedDraggedClientRecord atIndex:duplicatedDraggedClientRecordIndex];
        
        duplicatedDraggedClientRecordIndex = NSNotFound;
        duplicatedDraggedClientRecord = nil;
    }
    
    dropPlaceholderIndex = NSNotFound;
    [self setNeedsDisplay:YES];
}

- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender;
{
    return YES;
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender;
{
    NSPasteboard *draggingPasteboard;
    OAPreferenceClientRecord *clientRecord;
    unsigned int dropIndex;
    
    dropIndex = dropPlaceholderIndex;
    dropPlaceholderIndex = NSNotFound;
    [self setNeedsDisplay:YES];

    if (dropIndex == NSNotFound)
        return NO;

    draggingPasteboard = [sender draggingPasteboard];
    if ([draggingPasteboard availableTypeFromArray:[NSArray arrayWithObject:OAPreferencesIconDragType]] == nil)
        return NO;
        
    clientRecord = [[OAPreferenceController sharedPreferenceController] clientRecordWithShortTitle:[draggingPasteboard stringForType:OAPreferencesIconDragType]];
    if (clientRecord == nil)
        return NO;
        
    [favoriteClientRecords insertObject:clientRecord atIndex:dropIndex];
    return YES;
}

- (void)concludeDragOperation:(id <NSDraggingInfo>)sender;
{
    duplicatedDraggedClientRecordIndex = NSNotFound;
    duplicatedDraggedClientRecord = nil;

    [self _writeDefaults];
}


// OAPreferencesIconView

- (NSArray *)preferenceClientRecords;
{
    return favoriteClientRecords;
}

// OAPreferencesIconView (Subclasses)

- (unsigned int)_numberOfIcons;
{
    return [[self preferenceClientRecords] count] + ((dropPlaceholderIndex == NSNotFound) ? 0 : 1);
}

- (BOOL)_isIconSelectedAtIndex:(unsigned int)index;
{
    if (index < dropPlaceholderIndex)
        return [super _isIconSelectedAtIndex:index];
    else if (index > dropPlaceholderIndex)
        return [super _isIconSelectedAtIndex:index - 1];
    return NO;
}

- (BOOL)_iconImage:(NSImage **)image andName:(NSString **)name forIndex:(unsigned int)index;
{
    if (index < dropPlaceholderIndex)
        return [super _iconImage:image andName:name forIndex:index];
    else if (index > dropPlaceholderIndex)
        return [super _iconImage:image andName:name forIndex:index-1];

    // index == dropPlaceholderIndex
    *image = nil;
    *name = nil;
    return YES;
}

- (BOOL)_dragIconIndex:(unsigned int)index event:(NSEvent *)event;
{
    NSImage *iconImage;
    NSString *name;

    if (![self _iconImage:&iconImage andName:&name forIndex:index])
        return YES; // Yes, I handled your stinky bad call.
    
    pressedIconIndex = NSNotFound;
    [favoriteClientRecords removeObjectAtIndex:index];
    
    [self _dragIconImage:iconImage andName:name event:event];

    [self _writeDefaults]; // In case we dragged an icon off the dock
    return YES;
}

@end

@implementation OAPreferencesFavoritesIconView (Private)

- (void)_writeDefaults;
{
    NSUserDefaults *defaults;
    NSMutableArray *identifiersArray;
    unsigned int identifierIndex, identifierCount;

    identifiersArray = [NSMutableArray array];
    identifierCount = [favoriteClientRecords count];
    for (identifierIndex = 0; identifierIndex < identifierCount; identifierIndex++) {
        [identifiersArray addObject:[[favoriteClientRecords objectAtIndex:identifierIndex] identifier]];
    }

    defaults = [NSUserDefaults standardUserDefaults];
    [defaults setObject:identifiersArray forKey:favoritePreferencesKey];
    [defaults autoSynchronize];
}

@end
