// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OACalendarView.h,v 1.7 2001/04/30 23:53:57 krevis Exp $

#import <AppKit/NSControl.h>

@class NSCalendarDate, NSMutableArray;
@class NSTableHeaderCell, NSTextFieldCell;
@class OACalendarView;

#import <AppKit/NSNibDeclarations.h>

@protocol OACalendarViewDataSourceProtocol
- (int)calendarView:(OACalendarView *)aCalendarView highlightMaskForVisibleMonth:(NSCalendarDate *)visibleMonth;
@end

@interface OACalendarView : NSControl
{
    NSCalendarDate *visibleMonth;
    NSCalendarDate *selectedDay;

    NSTextFieldCell *monthTextFieldCell;
    NSTextFieldCell *yearTextFieldCell;
    NSTableHeaderCell *dayOfWeekCell[7];
    NSTextFieldCell *dayOfMonthCell;
    NSMutableArray *buttons;

    float columnWidth;
    float rowHeight;
    int dayHighlightMask;
}

+ (Class)cellClass;

- (id)initWithFrame:(NSRect)frameRect;
- (void)dealloc;

- (NSCalendarDate *)visibleMonth;
- (void)setVisibleMonth:(NSCalendarDate *)aDate;

- (NSCalendarDate *)selectedDay;
- (void)setSelectedDay:(NSCalendarDate *)newSelectedDay;

- (int)dayHighlightMask;
- (void)setDayHighlightMask:(int)newMask;

- (void)updateHighlightMask;

- (void)sizeToFit;

- (BOOL)isFlipped;
- (void)drawRect:(NSRect)rect;
- (void)drawDaysOfMonthInRect:(NSRect)rect;
- (void)drawGridInRect:(NSRect)rect;

- (float)_maxDayOfWeekWidth;
- (NSSize)_maxDayOfMonthSize;
- (float)_columnWidth;
- (float)_calendarWidth;
- (float)_rowHeight;
- (NSRect)_calendarDaysRect;

- (NSCalendarDate *)hitDateWithLocation:(NSPoint)targetPoint;
- (void)mouseDown:(NSEvent *)mouseEvent;

// Actions
- (IBAction)previousMonth:(id)sender;
- (IBAction)nextMonth:(id)sender;
- (IBAction)previousYear:(id)sender;
- (IBAction)nextYear:(id)sender;

@end
