// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Carbon/OAAppleScript.h,v 1.2 2001/08/30 00:43:14 rick Exp $

#import <Foundation/NSObject.h>
#import <Carbon/Carbon.h>

@class NSString, NSData;

@interface OAAppleScript : NSObject
{
    OSAID              _scriptId;
}

- initWithContentsOfFile:(NSString *)filename;
- initWithScriptData:(NSData *)scriptData;
- initWithScriptString: (NSString *) scriptString;
- (NSString *) execute;

// Utility methods build on OAAppleScript
+ (NSString *) executeScriptString: (NSString *) scriptString;

+ (void) sendMailTo:(NSString *) receiver
         carbonCopy:(NSString *) carbonCopy
            subject:(NSString *) subject
               body:(NSString *) body;
@end
