// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAFindPattern.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OAFindPattern.m,v 1.4 2001/08/19 21:44:49 kc Exp $")

@implementation OAFindPattern
 
- initWithString:(NSString *)aString ignoreCase:(BOOL)ignoreCase wholeWord:(BOOL)isWholeWord backwards:(BOOL)backwards;
{
    [super init];
    pattern = [aString retain];
    optionsMask = 0;
    if (ignoreCase)
        optionsMask |= NSCaseInsensitiveSearch;
    if (backwards)
        optionsMask |= NSBackwardsSearch;
    wholeWord = isWholeWord;
    return self;
}

- (void)dealloc;
{
    [pattern release];
    [super dealloc];
}

//
// OAFindPattern protocol
//

- (BOOL)findInString:(NSString *)aString foundRange:(NSRangePointer)rangePtr;
{
    return [self findInRange:NSMakeRange(0, [aString length]) ofString:aString foundRange:rangePtr];
}

- (BOOL)findInRange:(NSRange)range ofString:(NSString *)aString foundRange:(NSRangePointer)rangePtr;
{
    NSCharacterSet *wordSet;
    unsigned int stringLength;
    NSRange foundRange;
    
    wordSet = [NSCharacterSet letterCharacterSet];
    stringLength = [aString length];
    
    while (1) {
        foundRange = [aString rangeOfString:pattern options:optionsMask range:range];
        if (foundRange.length == 0)
            return NO;
        if (!wholeWord)
            break;

        if ((foundRange.location != 0 && [wordSet characterIsMember:[aString characterAtIndex:foundRange.location - 1]]) ||
            (NSMaxRange(foundRange) != stringLength && [wordSet characterIsMember:[aString characterAtIndex:NSMaxRange(foundRange)]])) {
            if (optionsMask & NSBackwardsSearch)
                range.length = foundRange.location - range.location;
            else {
                range.length = NSMaxRange(range) - NSMaxRange(foundRange);
                range.location = NSMaxRange(foundRange);
            }
            continue;
        }
        break;
    }
    if (rangePtr != NULL)
        *rangePtr = foundRange;
    return YES;
}

@end
