// Copyright 1998-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "NSFileWrapper-OAExtensions.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OpenStepExtensions.subproj/NSFileWrapper-OAExtensions.m,v 1.5 2001/02/15 15:12:35 kc Exp $")

@implementation NSFileWrapper (OAExtensions)
@end

@interface NSFileWrapper (OABugFix)
- (BOOL)OAWriteToFile:(NSString *)path atomically:(BOOL)atomicFlag updateFilenames:(BOOL)updateFilenamesFlag;
@end

@implementation NSFileWrapper (OABugFix)

static BOOL (*originalWriteToFileIMP)(id, SEL, NSString *, BOOL, BOOL);

+ (void)didLoad;
{
    originalWriteToFileIMP = (typeof(originalWriteToFileIMP))OBReplaceMethodImplementationWithSelector(self, @selector(writeToFile:atomically:updateFilenames:), @selector(OAWriteToFile:atomically:updateFilenames:));
}

- (BOOL)OAWriteToFile:(NSString *)path atomically:(BOOL)atomicFlag updateFilenames:(BOOL)updateFilenamesFlag;
{
    BOOL success;

    success = originalWriteToFileIMP(self, _cmd, path, atomicFlag, updateFilenamesFlag);
    if (success) {
        NSFileManager *defaultManager;

        defaultManager = [NSFileManager defaultManager];
        [defaultManager changeFileAttributes:[NSDictionary dictionaryWithObject:[defaultManager defaultDirectoryPermissions] forKey:NSFilePosixPermissions] atPath:path];
    }
    return success;
}

@end
