// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OAChasingArrowsProgressIndicator.h"

#import <Cocoa/Cocoa.h>
#import <ApplicationServices/ApplicationServices.h>
#import <OmniBase/OmniBase.h>

#import "NSImage-OAExtensions.h"


RCS_ID("$Header: /NetworkDisk/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAChasingArrowsProgressIndicator.m,v 1.16 2001/09/13 07:54:23 corwin Exp $")

#define FRAMES_PER_CYCLE  (16)
#define CYCLES_PER_SECOND (1.0)

#define FRAMES_PER_SECOND ((float)(FRAMES_PER_CYCLE * CYCLES_PER_SECOND))

static NSImage *ChasingArrows = nil;

@implementation OAChasingArrowsProgressIndicator

+ (void)initialize;
{
    OBINITIALIZE;
    
    ChasingArrows = [[NSImage imageNamed:@"OAChasingArrows" inBundleForClass:[OAChasingArrowsProgressIndicator class]] retain];
}

// Init and dealloc

- initWithFrame:(NSRect)newFrame;
{
    if ([super initWithFrame:newFrame] == nil)
        return nil;

    [self setIndeterminate:YES];
    [self setAnimationDelay:1.0 / FRAMES_PER_SECOND];
    
    return self;
}


// API

- (void)setTarget:(id)aTarget;
{
    nonretainedTarget = aTarget;
}

- (void)setAction:(SEL)newAction;
{
    action = newAction;
}

- (NSSize)preferredSize;
{
    return NSMakeSize(16.0, 16.0);
}

// NSResponder

- (void)mouseUp:(NSEvent *)theEvent;
{
    [NSApp sendAction:action to:nonretainedTarget from:self];
}

// NSView

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent;
{
    return YES;
}

- (BOOL)isFlipped;
{
    return NO;
}

- (void)drawRect:(NSRect)rect;
{
    float angle;
    float opacity;
    CGContextRef graphicsContext;
    NSRect bounds;

    // If we're not animating and there is no action, don't draw, because clicking will do nothing
    if (!animating && (!action || [[NSUserDefaults standardUserDefaults] boolForKey:@"OAStandardChasingArrowsBehavior"]))
        return;

    if (!animating) {
        counter = 0;
        angle = 0;
        opacity = 0.6;
    } else {
        counter++;
        angle = ((counter % FRAMES_PER_CYCLE) / (float)FRAMES_PER_CYCLE)  * (2.0 * M_PI);
        opacity = 1.0;
    }

    bounds = [self bounds];
    
    graphicsContext = (CGContextRef)[[NSGraphicsContext currentContext] graphicsPort];
    CGContextSaveGState(graphicsContext);

    if (angle != 0) {
        CGContextTranslateCTM(graphicsContext, NSWidth(bounds) / 2.0, NSHeight(bounds) / 2.0);
        CGContextRotateCTM(graphicsContext, -angle);
        CGContextTranslateCTM(graphicsContext, -NSWidth(bounds) / 2.0, -NSHeight(bounds) / 2.0);
    }
    
    [ChasingArrows drawInRect:bounds fromRect:NSZeroRect operation:NSCompositeSourceOver fraction:opacity];

    CGContextRestoreGState(graphicsContext);
}

- (BOOL)isOpaque;
{
    return NO;
}

// NSProgressIndicator

- (void)startAnimation:(id)sender;
{
    animating = YES;
    [super startAnimation:sender];
}

- (void)stopAnimation:(id)sender;
{
    animating = NO;
    [super stopAnimation:sender];
    [self setNeedsDisplay:YES];
}

@end
