// Copyright 2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OARegExFindPattern.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/OARegExFindPattern.m,v 1.5 2001/10/21 07:17:35 kc Exp $")

@implementation OARegExFindPattern

- initWithString:(NSString *)aString selectedSubexpression:(int)subexpression backwards:(BOOL)backwards;
{
    [super init];
    regularExpression = [[OFRegularExpression alloc] initWithString:aString];
    selectedSubexpression = subexpression;
    isBackwards = backwards;
    return self;
}

- (void)dealloc;
{
    [regularExpression release];
    [super dealloc];
}

//
// OAFindPattern protocol
//

- (BOOL)findInString:(NSString *)aString foundRange:(NSRangePointer)rangePtr;
{
    OFRegularExpressionMatch *match;
    
    if (aString == nil)
        return NO;

    if (!(match = [regularExpression matchInString:aString]))
        return NO;
        
    if (isBackwards) {
        OFRegularExpressionMatch *next;

        while ((next = [match nextMatch]))
            match = next;
    }
        
    if (rangePtr != NULL) {
        if (selectedSubexpression == SELECT_FULL_EXPRESSION)
            *rangePtr = [match matchRange];
        else
            *rangePtr = [match rangeOfSubexpressionAtIndex:selectedSubexpression];
    }
    return YES;
}

- (BOOL)findInRange:(NSRange)range ofString:(NSString *)aString foundRange:(NSRangePointer)rangePtr;
{
    BOOL result;
    
    if (aString == nil)
        return NO;

    result = [self findInString:[aString substringWithRange:range] foundRange:rangePtr];
    if (rangePtr != NULL)
        rangePtr->location += range.location;
    return result;
}

@end
