// Copyright 2000-2001 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniAppKit/OAAquaButton.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/NSWindow-OAExtensions.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniAppKit/Widgets.subproj/OAAquaButton.m,v 1.11 2001/08/10 21:04:02 kc Exp $")

static NSString *OAAquaClearSuffix = @"Clear";

@interface NSView (NotYetPublicKeyChangedAPI)
- (void) _windowChangedKeyState;
@end

@interface OAAquaButton (PrivateAPI)
+ (void) _controlTintChanged: (NSNotification *) note;
@end

@implementation OAAquaButton

- (void)dealloc;
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [aquaImage release];
    [graphiteImage release];
    [clearImage release];
    [super dealloc];
}

- (void) setImage: (NSImage *) image;
{
    [aquaImage release];
    aquaImage = nil;
    [graphiteImage release];
    graphiteImage = nil;
    [clearImage release];
    clearImage = nil;

    // This will schedule a redraw
    [super setImage: image];
}

// NSView subclass

- (void)drawRect: (NSRect) rect;
{
    if (!aquaImage)
        [self cacheImages];
    [super drawRect: rect];
}

// This will be made public in some form after Public Beta
- (void) _windowChangedKeyState;
{
    if ([_window shouldDrawAsKey]) {
        if (OACurrentControlTint() == OAGraphiteTint) {
            if (graphiteImage) {
                [super setImage: graphiteImage];
            }
        } else if (aquaImage) {
            [super setImage: aquaImage];
        }
    } else {
        if (clearImage) {
            [super setImage: clearImage];
        }
    }
}


@end


@implementation OAAquaButton (SubclassesOnly)

- (void)cacheImages;
{
    NSString *imageName;
    NSImage  *image;
    
    image = [self image];
    
    [aquaImage release];
    aquaImage = [image retain];
    [clearImage release];
    clearImage = nil;
    
    imageName = [[aquaImage name] stringByAppendingString:OAAquaClearSuffix];
    if (imageName)
        clearImage = [[NSImage imageNamed: imageName] retain];

    imageName = [[aquaImage name] stringByAppendingString:OAAquaGraphiteSuffix];
    if (imageName)
        graphiteImage = [[NSImage imageNamed: imageName] retain];

    // Set the images directly on the cells to avoid scheduling another
    // redraw.  We get called in the middle of draw rect the first time
    // around and don't want to be inefficient by drawing again after
    // caching images.
    if ([_window shouldDrawAsKey]) {
        if (OACurrentControlTint() == OAGraphiteTint) {
            if (graphiteImage) {
                [[self cell] setImage: graphiteImage];
            }
        } else if (aquaImage) {
            [[self cell] setImage: aquaImage];
        }
    } else {
        if (clearImage) {
            [[self cell] setImage: clearImage];
        }
    }
}

@end


@implementation OAAquaButton (PrivateAPI)

static volatile BOOL registered = NO;
static volatile int cachedTint = OAUndefinedTint;

+ (void)_controlTintChanged:(NSNotification *)note;
{
    cachedTint = OAUndefinedTint;
    [[NSNotificationCenter defaultCenter] postNotificationName:OAControlTintDidChangeNotification object:nil];
}

OmniAppKit_EXTERN OAControlTint OACurrentControlTint()
{
    int currentTint;
    
    if (!registered) {
        // There is a tiny, tiny race condition here, which could get us registered twice. No real harm should come of that, though.
        registered = YES;
        [[NSNotificationCenter defaultCenter] addObserver:[OAAquaButton class] selector:@selector(_controlTintChanged:) name:NSControlTintDidChangeNotification object:nil];
    }
    currentTint = cachedTint;
    if (currentTint == OAUndefinedTint) {
        NSColor *controlTintRGBColor;
        float hue = 0.0, saturation = 0.0, brightness = 0.0, alpha = 0.0;
    
        controlTintRGBColor = [[NSColor colorForControlTint:NSDefaultControlTint] colorUsingColorSpaceName:NSDeviceRGBColorSpace];
        [controlTintRGBColor getHue:&hue saturation:&saturation brightness:&brightness alpha:&alpha];
        if (alpha == 0.0) // Color values bogus, use default
            currentTint = OAAquaTint;
        else if (saturation < 0.1)
            currentTint = OAGraphiteTint; // Graphite: hue=0.595238, saturation=0.087500, brightness=0.800000
        else
            currentTint = OAAquaTint; // Aqua: hue=0.583333, saturation=0.329670, brightness=0.910000
        cachedTint = currentTint;
    }
    return currentTint;
}

@end

DEFINE_NSSTRING(OAControlTintDidChangeNotification);

NSString *OAAquaGraphiteSuffix = @"Graphite";
